/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.email;

import de.ponton.xmlpipe.rest.settings.email.EmailTestRequestDto;
import de.ponton.xmlpipe.rest.settings.email.EmailTestResultDto;
import de.ponton.xmlpipe.rest.settings.email.EmailTestService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/settings/email"})
public class EmailSettingsController {
    public static final String DOCUMENTATION_TAG_SETTINGS_EMAIL = "Settings / Email";
    private final EmailTestService emailTestService;

    public EmailSettingsController(EmailTestService emailTestService) {
        this.emailTestService = emailTestService;
    }

    @Operation(summary="Test Email", description="permission:SETTINGS_EMAIL_TEST_POST<br><br>Tests the functionality of sending e-mails with the messenger.", tags={"Settings / Email"})
    @PostMapping(value={"/test"})
    @Secured(value={"SETTINGS_EMAIL_TEST_POST"})
    public ResponseEntity<EmailTestResultDto> testEmail(@Valid @RequestBody EmailTestRequestDto emailTestRequestDto) {
        EmailTestResultDto emailTestResultDto = this.emailTestService.sendTestMessage(emailTestRequestDto);
        return ResponseEntity.status((HttpStatusCode)(emailTestResultDto.isFailed() ? HttpStatus.BAD_REQUEST : HttpStatus.OK)).body((Object)emailTestResultDto);
    }
}

