/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.communication;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about LDAP proxy configuration for the communication configuration of the messenger.")
public class LdapProxyConfigDto {
    @NotBlank
    @Size(max=1024)
    @Schema(description="The IP address or hostname of your LDAP proxy server.")
    @TrimmedField
    private @NotBlank @Size(max=1024) String host;
    @NotNull
    @Min(value=1L)
    @Max(value=65535L)
    @Schema(description="The port of your LDAP proxy server.")
    private @NotNull @Min(value=1L) @Max(value=65535L) Integer port;

    public String getHost() {
        return this.host;
    }

    public LdapProxyConfigDto setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public LdapProxyConfigDto setPort(Integer port) {
        this.port = port;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LdapProxyConfigDto)) {
            return false;
        }
        LdapProxyConfigDto that = (LdapProxyConfigDto)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return "LdapProxyConfigDto{host='" + this.host + "', port=" + this.port + "}";
    }
}

