/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.communication;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.settings.common.authentication.AuthenticationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about HTTP proxy configuration for the communication configuration of the messenger.")
public class HttpProxyConfigDto {
    @NotBlank
    @Size(max=1024)
    @Schema(description="The IP address or hostname of your HTTP proxy server.")
    @TrimmedField
    private @NotBlank @Size(max=1024) String host;
    @NotNull
    @Min(value=1L)
    @Max(value=65535L)
    @Schema(description="The port of your HTTP proxy server.")
    private @NotNull @Min(value=1L) @Max(value=65535L) Integer port;
    @Valid
    @Schema(description="The authentication information of your HTTP proxy server if required.")
    private AuthenticationDto authentication;
    @Size(max=1024)
    @Schema(description="The NT domain of your HTTP proxy server.")
    @TrimmedField
    private @Size(max=1024) String ntDomain;
    @NotNull
    @Schema(description="A list of IPs or fully qualified hostnames which shall be ignored for the communication via proxy.")
    private @NotNull List<@NotBlank @Size(max=1024) String> bypassProxyFor;

    public String getHost() {
        return this.host;
    }

    public HttpProxyConfigDto setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public HttpProxyConfigDto setPort(Integer port) {
        this.port = port;
        return this;
    }

    public AuthenticationDto getAuthentication() {
        return this.authentication;
    }

    public HttpProxyConfigDto setAuthentication(AuthenticationDto authentication) {
        this.authentication = authentication;
        return this;
    }

    public String getNtDomain() {
        return this.ntDomain;
    }

    public HttpProxyConfigDto setNtDomain(String ntDomain) {
        this.ntDomain = ntDomain;
        return this;
    }

    public List<String> getBypassProxyFor() {
        return this.bypassProxyFor;
    }

    public HttpProxyConfigDto setBypassProxyFor(List<String> bypassProxyFor) {
        this.bypassProxyFor = new ArrayList<String>(bypassProxyFor);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpProxyConfigDto)) {
            return false;
        }
        HttpProxyConfigDto that = (HttpProxyConfigDto)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.ntDomain, that.ntDomain) && Objects.equals(this.bypassProxyFor, that.bypassProxyFor);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.authentication, this.ntDomain, this.bypassProxyFor);
    }

    public String toString() {
        return "HttpProxyConfigDto{host='" + this.host + "', port=" + this.port + ", authentication=" + String.valueOf(this.authentication) + ", ntDomain='" + this.ntDomain + "', bypassProxyFor=" + String.valueOf(this.bypassProxyFor) + "}";
    }
}

