/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.communication;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.settings.common.authentication.AuthenticationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about FTP proxy configuration for the communication configuration of the messenger.")
public class FtpProxyConfigDto {
    @NotBlank
    @Size(max=1024)
    @Schema(description="The IP address or hostname of your FTP proxy server.")
    @TrimmedField
    private @NotBlank @Size(max=1024) String host;
    @NotNull
    @Min(value=1L)
    @Max(value=65535L)
    @Schema(description="The port of your FTP proxy server.")
    private @NotNull @Min(value=1L) @Max(value=65535L) Integer port;
    @Valid
    @Schema(description="The authentication information of your FTP proxy server if required.")
    private AuthenticationDto authentication;

    public String getHost() {
        return this.host;
    }

    public FtpProxyConfigDto setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public FtpProxyConfigDto setPort(Integer port) {
        this.port = port;
        return this;
    }

    public AuthenticationDto getAuthentication() {
        return this.authentication;
    }

    public FtpProxyConfigDto setAuthentication(AuthenticationDto authentication) {
        this.authentication = authentication;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtpProxyConfigDto)) {
            return false;
        }
        FtpProxyConfigDto that = (FtpProxyConfigDto)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.authentication, that.authentication);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.authentication);
    }

    public String toString() {
        return "FtpProxyConfigDto{host='" + this.host + "', port=" + this.port + ", authentication=" + String.valueOf(this.authentication) + "}";
    }
}

