/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.archive;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.LocalTime;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about cleanup configuration for the archive or database of the messenger.")
public class CleanupDto {
    @NotNull
    @Min(value=1L)
    @Max(value=10000L)
    @Schema(description="Specifies the maximum number of days the archived message parts should be retained.")
    private @NotNull @Min(value=1L) @Max(value=10000L) Integer maxAge;
    @NotNull
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Schema(description="The time at which the cleanup of outdated messages should be done.", example="10:00:00")
    private LocalTime cleanupTime;
    @NotNull
    @Min(value=0L)
    @Schema(description="The maximum time (in minutes) the cleanup thread should run. If not all outdated messages could be deleted in this period, the deletion will continue the next day at configured 'cleanupTime'. An empty value of 0 means no runtime limitation", example="120")
    private @NotNull @Min(value=0L) Integer cleanupMaxRuntime;

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public CleanupDto setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public Integer getCleanupMaxRuntime() {
        return this.cleanupMaxRuntime;
    }

    public CleanupDto setCleanupMaxRuntime(Integer cleanupMaxRuntime) {
        this.cleanupMaxRuntime = cleanupMaxRuntime;
        return this;
    }

    public LocalTime getCleanupTime() {
        return this.cleanupTime;
    }

    public CleanupDto setCleanupTime(@NotNull LocalTime cleanupTime) {
        this.cleanupTime = cleanupTime;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CleanupDto)) {
            return false;
        }
        CleanupDto that = (CleanupDto)o;
        return Objects.equals(this.maxAge, that.maxAge) && Objects.equals(this.cleanupTime, that.cleanupTime) && Objects.equals(this.cleanupMaxRuntime, that.cleanupMaxRuntime);
    }

    public int hashCode() {
        return Objects.hash(this.maxAge, this.cleanupTime, this.cleanupMaxRuntime);
    }

    public String toString() {
        return "CleanupDto{maxAge=" + this.maxAge + ", cleanupTime=" + String.valueOf(this.cleanupTime) + ", cleanupMaxRuntime=" + this.cleanupMaxRuntime + "}";
    }
}

