/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings;

import de.ponton.xmlpipe.rest.settings.display.DisplayDto;
import de.ponton.xmlpipe.rest.settings.display.MessengerConfigurationDisplayFactory;
import de.pontonconsulting.xmlpipe.config.MessengerConfigLoader;
import de.pontonconsulting.xmlpipe.config.model.messenger.XpMessengerConfigurationDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.xml.bind.JAXBException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/display"})
public class DisplayController {
    private static final String DOCUMENTATION_TAG = "Display";
    private final MessengerConfigLoader configLoader;
    private final MessengerConfigurationDisplayFactory displayFactory;

    public DisplayController(MessengerConfigLoader configLoader, MessengerConfigurationDisplayFactory displayFactory) {
        this.configLoader = configLoader;
        this.displayFactory = displayFactory;
    }

    @Operation(summary="Get public display settings", description="", tags={"Display"})
    @SecurityRequirements
    @GetMapping
    public ResponseEntity<DisplayDto> getDisplay() throws MalformedURLException, JAXBException, URISyntaxException {
        XpMessengerConfigurationDto xpConfigurationDto = this.configLoader.getConfigurationDto();
        DisplayDto displayDto = this.displayFactory.create(xpConfigurationDto.getDisplay());
        return ResponseEntity.ok((Object)displayDto);
    }
}

