/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.server.certificate;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.PasswordStrengthConstraint;
import de.pontonconsulting.xmlpipe.admintool.messenger.ssl.certificate.KeyPairAlgorithm;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;

public class CreateServerCertificateRequestDto {
    @NotBlank
    @Schema(description="The common name. This is the fully qualified domain name that you wish to secure.")
    @TrimmedField
    private String cn;
    @Schema(description="The organzational unit. Internal organization department/division name.")
    @TrimmedField
    private String ou;
    @NotBlank
    @Schema(description="The organization name. Usually the legal name of a company or entity and should include any suffixes such as Ltd., Inc., or Corp.")
    @TrimmedField
    private String o;
    @Schema(description="The locality. Town, city, village, etc. name.")
    @TrimmedField
    private String l;
    @Schema(description="Province, region, county or state. This should not be abbreviated (e.g. West Sussex, Normandy, New Jersey).")
    @TrimmedField
    private String st;
    @NotBlank
    @Schema(description="The country. The two-letter ISO code for the country where your organization is located")
    @TrimmedField
    private String c;
    @NotBlank
    @Email
    @Schema(description="The organization contact, usually of the certificate administrator or IT department")
    @TrimmedField
    private String email;
    @Schema(description="The fax number of the organization.")
    @TrimmedField
    private String fax;
    @Schema(description="The phone number of the organization.")
    @TrimmedField
    private String phone;
    @Schema(description="The keystore password")
    @NotBlank
    @PasswordStrengthConstraint
    private String password;
    @Schema(description="SAN (Subject Alternative Name)")
    @Size(min=1)
    private @Size(min=1) List<@NotBlank String> san = new ArrayList<String>();
    @Schema(description="This flag defines if non-standard data is included in the certificate request. Should only be activated when the CSR will be signed by PONTON CA")
    private boolean extensions;
    @Schema(description="The KeyPairAlgorithm for the certificate")
    private KeyPairAlgorithm algorithm = KeyPairAlgorithm.RSA_2048;

    public String getCn() {
        return this.cn;
    }

    public CreateServerCertificateRequestDto setCn(String cn) {
        this.cn = cn;
        return this;
    }

    public String getOu() {
        return this.ou;
    }

    public CreateServerCertificateRequestDto setOu(String ou) {
        this.ou = ou;
        return this;
    }

    public String getO() {
        return this.o;
    }

    public CreateServerCertificateRequestDto setO(String o) {
        this.o = o;
        return this;
    }

    public String getL() {
        return this.l;
    }

    public CreateServerCertificateRequestDto setL(String l) {
        this.l = l;
        return this;
    }

    public String getSt() {
        return this.st;
    }

    public CreateServerCertificateRequestDto setSt(String st) {
        this.st = st;
        return this;
    }

    public String getC() {
        return this.c;
    }

    public CreateServerCertificateRequestDto setC(String c) {
        this.c = c;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public CreateServerCertificateRequestDto setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getFax() {
        return this.fax;
    }

    public CreateServerCertificateRequestDto setFax(String fax) {
        this.fax = fax;
        return this;
    }

    public String getPhone() {
        return this.phone;
    }

    public CreateServerCertificateRequestDto setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public CreateServerCertificateRequestDto setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean isExtensions() {
        return this.extensions;
    }

    public CreateServerCertificateRequestDto setExtensions(boolean extensions) {
        this.extensions = extensions;
        return this;
    }

    public KeyPairAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public CreateServerCertificateRequestDto setAlgorithm(KeyPairAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public List<String> getSan() {
        return this.san;
    }

    public CreateServerCertificateRequestDto setSan(List<String> san) {
        this.san = san;
        return this;
    }
}

