/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.server.ca;

import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.certificate.CertificateDtoFactory;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import de.ponton.xmlpipe.rest.validation.X509CertificateConstraint;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.SSLKeystoreBean;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/serverca"})
@Validated
public class ServerCertificateAuthorityController {
    public static final String DOCUMENTATION_TAG_SERVER_CE_CERTIFICATE = "Server CA Certificate";
    private final SSLKeystoreBean keystoreBean;
    private final CertificateDtoFactory certificateDtoFactory;
    private final CertificateUtility certificateUtility;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public ServerCertificateAuthorityController(SSLKeystoreBean keystoreBean, CertificateDtoFactory certificateDtoFactory, CertificateUtility certificateUtility, ExceptionDtoFactory exceptionDtoFactory) {
        this.keystoreBean = keystoreBean;
        this.certificateDtoFactory = certificateDtoFactory;
        this.certificateUtility = certificateUtility;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @Operation(summary="Get all Server CA Certificates", description="permission:SERVERCA_GET<br><br>Returns a list of all Server CA Certificates", tags={"Server CA Certificate"})
    @GetMapping
    @Secured(value={"SERVERCA_GET"})
    public ResponseEntity<List<CertificateDto>> getAllCertificateAuthority() throws KeyStoreException {
        Enumeration<String> sslAliases = this.keystoreBean.getSslAliases();
        ArrayList<CertificateDto> list = new ArrayList<CertificateDto>();
        while (sslAliases.hasMoreElements()) {
            String alias = sslAliases.nextElement();
            list.add(this.certificateDtoFactory.create(this.keystoreBean.getSslCA(alias)).setId(Base64.getEncoder().encodeToString(alias.getBytes(StandardCharsets.UTF_8))));
        }
        return ResponseEntity.ok(list);
    }

    @Operation(summary="Get a single Server CA Certificates", description="permission:SERVERCA_GET<br><br>The id is the BASE64 encoded alias", tags={"Server CA Certificate"})
    @GetMapping(value={"/{id}"})
    @Secured(value={"SERVERCA_GET"})
    public ResponseEntity<CertificateDto> getCertificateAuthority(@PathVariable String id) throws KeyStoreException {
        String alias = new String(Base64.getDecoder().decode(id));
        X509Certificate certificate = this.keystoreBean.getSslCA(alias);
        if (certificate == null) {
            throw new ResourceNotFoundException();
        }
        return ResponseEntity.ok((Object)this.certificateDtoFactory.create(certificate).setId(id));
    }

    @Operation(summary="Post a Server CA Certificate", description="permission:SERVERCA_POST<br><br>Returns the stored CA Certificate, the Id is the BASE64 encoded alias", tags={"Server CA Certificate"})
    @Validated(value={ValidationGroup.Create.class})
    @PostMapping
    @Secured(value={"SERVERCA_POST"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<CertificateDto> postCertificateAuthority(@Valid @X509CertificateConstraint @RequestBody String certificate) throws KeyStoreException, InstallCertException, CertificateException, NoSuchProviderException {
        X509Certificate x509Certificate = this.certificateUtility.getX509Certificate(certificate);
        String alias = this.certificateUtility.buildAliasForCA(x509Certificate);
        if (this.keystoreBean.getSslCA(alias) != null) {
            this.keystoreBean.deleteSslCA(alias);
        }
        this.keystoreBean.addSslCA(alias, x509Certificate);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.certificateDtoFactory.create(x509Certificate).setId(Base64.getEncoder().encodeToString(alias.getBytes(StandardCharsets.UTF_8))));
    }

    @Operation(summary="Delete a Server CA Certificate", description="permission:SERVERCA_DELETE<br><br>The id is the BASE64 encoded alias", tags={"Server CA Certificate"})
    @Validated(value={ValidationGroup.Update.class})
    @DeleteMapping(value={"/{id}"})
    @Secured(value={"SERVERCA_DELETE"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteCertificateAuthority(@PathVariable String id) throws KeyStoreException {
        String alias = new String(Base64.getDecoder().decode(id));
        X509Certificate certificate = this.keystoreBean.getSslCA(alias);
        if (certificate == null) {
            throw new ResourceNotFoundException();
        }
        this.keystoreBean.deleteSslCA(alias);
        return ResponseEntity.noContent().build();
    }

    @ExceptionHandler(value={KeyStoreException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ExceptionDto> handleInternalServerError(KeyStoreException e) {
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleInternalNotFound(ResourceNotFoundException e) {
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

