/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.registry;

import de.ponton.xmlpipe.rest.IDtoCreateFactory;
import de.ponton.xmlpipe.rest.registry.RegistryPartnerDto;
import de.ponton.xmlpipe.rest.registry.SyncState;
import de.pontonconsulting.xmlpipe.admintool.registry.index.IndexRecord;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class RegistryPartnerDtoFactory
implements IDtoCreateFactory<RegistryPartnerDto, IndexRecord> {
    private final PartnerProfileDAO partnerProfileDAO;

    public RegistryPartnerDtoFactory(PartnerProfileDAO partnerProfileDAO) {
        this.partnerProfileDAO = partnerProfileDAO;
    }

    @Override
    public RegistryPartnerDto create(IndexRecord valueObject) {
        return new RegistryPartnerDto().setDisplayName(valueObject.getDisplayName()).setLastModified(valueObject.getLastModified()).setOwner(valueObject.getPath()).setFilePath(valueObject.getFilePath()).setSynced(this.determineSyncState(valueObject)).setPartnerId(valueObject.getPartnerId());
    }

    private SyncState determineSyncState(IndexRecord valueObject) {
        Optional<PartnerProfile> profileOptional = this.partnerProfileDAO.getAllPartnerProfiles().stream().filter(profile -> valueObject.getFilePath().equalsIgnoreCase(profile.getRegistryPath())).findFirst();
        if (profileOptional.isPresent()) {
            if (profileOptional.get().getLastChange().toInstant().toEpochMilli() == valueObject.getLastModifiedLong()) {
                return SyncState.SYNCED;
            }
            return SyncState.NOT_SYNCED;
        }
        return SyncState.NOT_IMPORTED;
    }
}

