/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.registry;

import de.ponton.xmlpipe.rest.cpp.PartnerDto;
import de.ponton.xmlpipe.rest.cpp.PartnerDtoFactory;
import de.ponton.xmlpipe.rest.cpp.validation.RequiredLocalPartnerConstraint;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.registry.RegistryPartnerDto;
import de.ponton.xmlpipe.rest.registry.RegistryPartnerDtoFactory;
import de.pontonconsulting.xmlpipe.admintool.registry.index.IndexRecord;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.DuplicateProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.integration.WebDavIntegration;
import de.pontonconsulting.xmlpipe.registry.RegistryException;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/registry"})
@Validated
public class PartnerRegistryController {
    public static final String DOCUMENTATION_TAG = "Partner Registry";
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + PartnerRegistryController.class.getName()));
    private final RegistryPartnerDtoFactory registryPartnerDtoFactory;
    private final WebDavIntegration webDavIntegration;
    private final ExceptionDtoFactory exceptionDtoFactory;
    private final PartnerDtoFactory partnerDtoFactory;
    private final RegistryProfileUpdater registryProfileUpdater;
    private final Profiles profiles;

    public PartnerRegistryController(RegistryPartnerDtoFactory registryPartnerDtoFactory, WebDavIntegration webDavIntegration, ExceptionDtoFactory exceptionDtoFactory, RegistryProfileUpdater registryProfileUpdater, Profiles profiles, PartnerDtoFactory partnerDtoFactory) {
        this.registryPartnerDtoFactory = registryPartnerDtoFactory;
        this.webDavIntegration = webDavIntegration;
        this.exceptionDtoFactory = exceptionDtoFactory;
        this.registryProfileUpdater = registryProfileUpdater;
        this.profiles = profiles;
        this.partnerDtoFactory = partnerDtoFactory;
    }

    @Operation(summary="Get all registry partners", description="permission:REGISTRY_GET<br><br>Return a list of all registry partners", tags={"Partner Registry"})
    @GetMapping
    @Secured(value={"REGISTRY_GET"})
    public ResponseEntity<List<RegistryPartnerDto>> getRegistryPartners() throws RegistryException {
        if (!this.webDavIntegration.isRegistryEnabled()) {
            throw new IllegalStateException("Partner registry is disabled.");
        }
        Map<String, IndexRecord> indexRecords = this.webDavIntegration.getRegistryIndex(true);
        if (indexRecords == null) {
            throw new RegistryException(-1, "Download of Partner-Registry IndexRecord failed.");
        }
        return ResponseEntity.ok(indexRecords.values().stream().map(this.registryPartnerDtoFactory::create).collect(Collectors.toList()));
    }

    @Operation(summary="Import a partner from registry", description="permission:REGISTRY_IMPORT_POST<br><br>Import a partner that refers to the passed registry path. Backend-Id and Displayname are set to the imported partner. Return the imported partner", tags={"Partner Registry"})
    @PostMapping(value={"/import"})
    @Secured(value={"REGISTRY_IMPORT_POST"})
    public ResponseEntity<PartnerDto> importPartnerFromRegistry(@RequestParam @Parameter(description="The relative path to profile in registry") String registryPath, @RequestParam @Parameter(description="The backend-id for the partner") String backendId, @RequestParam @Parameter(description="The displayname for the partner") String displayname) throws ProfileException, RegistryException {
        if (!this.webDavIntegration.isRegistryEnabled()) {
            throw new IllegalStateException("Partner registry is disabled.");
        }
        this.webDavIntegration.getRegistryIndex(true);
        CppPartner cppPartner = this.profiles.importPartnerFromRegistry(registryPath, backendId, displayname);
        if (cppPartner.isRemote()) {
            this.registryProfileUpdater.pushCertificateToListener(cppPartner);
        }
        return ResponseEntity.ok((Object)this.partnerDtoFactory.create(cppPartner));
    }

    @Operation(summary="Indicates if registry is enabled", description="permission:REGISTRY_ENABLED_GET<br><br>The partner registry can be enabled/disabled via messenger configuration.", tags={"Partner Registry"})
    @Secured(value={"REGISTRY_ENABLED_GET"})
    @GetMapping(value={"/enabled"})
    public ResponseEntity<Boolean> isEnabled() throws ProfileException {
        return ResponseEntity.ok((Object)this.webDavIntegration.isRegistryEnabled());
    }

    @Operation(summary="Upload a partner to registry", description="permission:REGISTRY_UPLOAD_POST<br><br>Upload a partner related to the passed local id to registry. Local id must belong to a local partner", tags={"Partner Registry"})
    @PostMapping(value={"/upload/{localId}"})
    @Secured(value={"REGISTRY_UPLOAD_POST"})
    @RequiredLocalPartnerConstraint
    @Validated
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> uploadPartnerToRegistry(@PathVariable @Parameter(description="The local id of partner") String localId) throws ProfileException, RegistryException, AgreementException {
        if (!this.webDavIntegration.isRegistryEnabled()) {
            throw new IllegalStateException("Partner registry is disabled.");
        }
        CppPartner localProfile = this.profiles.getProfileForLocalId(localId, false);
        this.registryProfileUpdater.uploadLocalPartner(localProfile);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Synchronize Partner with registry", description="permission:REGISTRY_SYNCHRONIZE_POST<br><br>The partner profile is uploaded to or downloaded from the partner registry, so that configuration on Messenger is in sync with the Registry", tags={"Partner Registry"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Partner profile was synced with partner registry"), @ApiResponse(responseCode="409", description="Partner profile is not linked with partner registry"), @ApiResponse(responseCode="500", description="Partner Registry link is not configured or communication with Partner Registry failed")})
    @PostMapping(value={"/synchronize/{localId}"})
    @Secured(value={"REGISTRY_SYNCHRONIZE_POST"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> synchronizePartnerWithRegistry(@PathVariable @Parameter(description="The local id of partner") String localId) throws ProfileException, RegistryException, AgreementException {
        if (!this.webDavIntegration.isRegistryEnabled()) {
            throw new IllegalStateException("Partner registry is disabled.");
        }
        this.webDavIntegration.getRegistryIndex(true);
        CppPartner localProfile = this.profiles.getProfileForLocalId(localId, false);
        if (localProfile.getRemoteFile() == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
        if (localProfile.isRemote()) {
            this.registryProfileUpdater.updateProfile(localProfile);
        } else {
            this.registryProfileUpdater.uploadLocalPartner(localProfile);
        }
        return ResponseEntity.noContent().build();
    }

    @ExceptionHandler(value={RegistryException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ExceptionDto> handleRegistryException(RegistryException e) {
        LOG.error(String.format("Unexpected error when accessing partner registry. Error: %s", e.getMessage()), (Throwable)e);
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleIllegalStateException(IllegalStateException e) {
        LOG.warn("Partner registry is disabled.");
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ProfileNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleNotFound(Exception e) {
        LOG.error("Profile not found. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ProfileException.class, IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleBadRequest(Exception e) {
        LOG.error(String.format("Unexpected error when accessing partner registry. Error: %s", e.getMessage()));
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DuplicateProfileException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleDuplicateExceptionRequest(DuplicateProfileException e) {
        LOG.error(String.format("PartyId already exists. Error: %s", e.getMessage()));
        ExceptionDto exceptionDto = this.exceptionDtoFactory.create(e);
        exceptionDto.addErrorMessageParameter("key", e.key());
        exceptionDto.addErrorMessageParameter("value", e.value());
        return new ResponseEntity((Object)exceptionDto, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

