/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.plugableadaptersettings;

import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.plugableadaptersettings.PlugableAdapterConfigDto;
import de.ponton.xmlpipe.rest.plugableadaptersettings.PlugableAdapterConfigService;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/plugableAdapterConfig"})
@Validated
public class PlugableAdapterConfigController {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    public static final String DOCUMENTATION_TAG = "Plugable Adapter Configurations";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_APP_BINARY = "application/binary";
    private final PlugableAdapterConfigService plugableAdapterConfigService;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public PlugableAdapterConfigController(PlugableAdapterConfigService plugableAdapterConfigService, ExceptionDtoFactory exceptionDtoFactory) {
        this.plugableAdapterConfigService = plugableAdapterConfigService;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @Operation(summary="List Plugable Adapter Configs", description="permission:PLUGABLE_ADAPTER_SETTINGS_GET<br><br>List stored Plugable Adapter Configs", tags={"Plugable Adapter Configurations"})
    @GetMapping
    @Secured(value={"PLUGABLE_ADAPTER_SETTINGS_GET"})
    public ResponseEntity<List<PlugableAdapterConfigDto>> getAllConfigs() {
        List<PlugableAdapterConfigDto> configs = this.plugableAdapterConfigService.getAllPlugableAdapterConfigs();
        return ResponseEntity.ok(configs);
    }

    @Operation(summary="Download a Plugable Adapter Config", description="permission:PLUGABLE_ADAPTER_SETTINGS_POST<br><br>Download a plugable adapter config, the original filename of the file is the id", tags={"Plugable Adapter Configurations"})
    @GetMapping(value={"/{filename}"})
    @Secured(value={"PLUGABLE_ADAPTER_SETTINGS_GET"})
    public void getPluginAdapterConfig(HttpServletResponse response, @PathVariable String filename) throws IOException {
        response.setHeader("Access-Control-Expose-Headers", CONTENT_DISPOSITION);
        response.setHeader(CONTENT_TYPE, CONTENT_TYPE_APP_BINARY);
        response.setHeader(CONTENT_DISPOSITION, String.format("attachment; filename=\"%s\"", filename));
        this.plugableAdapterConfigService.readPlugableAdapterConfig(filename, (OutputStream)response.getOutputStream());
    }

    @Operation(summary="Upload a Plugable Adapter Config", description="permission:PLUGABLE_ADAPTER_SETTINGS_POST<br><br>Uploads a new plugable adapter config, if the filename already exists on DB, it will be overwritten", tags={"Plugable Adapter Configurations"})
    @PostMapping(consumes={"multipart/form-data"})
    @Secured(value={"PLUGABLE_ADAPTER_SETTINGS_POST"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> uploadPlugableAdapterConfig(@RequestPart MultipartFile file) throws IOException {
        this.plugableAdapterConfigService.storePlugableAdapterConfig(file.getOriginalFilename(), file.getInputStream());
        return ResponseEntity.status((int)201).build();
    }

    @Operation(summary="Delete a Plugable Adapter Config", description="permission:PLUGABLE_ADAPTER_SETTINGS_DELETE<br><br>Deletes an existing Pugable Adapter Config", tags={"Plugable Adapter Configurations"})
    @DeleteMapping(value={"/{filename}"})
    @Secured(value={"PLUGABLE_ADAPTER_SETTINGS_DELETE"})
    public void deletePlugableAdapterConfig(@PathVariable String filename) throws IOException {
        this.plugableAdapterConfigService.deletePlugableAdapterConfig(filename);
    }

    @ExceptionHandler(value={KeyStoreException.class, InstallCertException.class, GeneralSecurityException.class})
    public ResponseEntity<ExceptionDto> handleBadRequest(Exception e) {
        this.log.error("Plugable Adapter Config does not exist. Error: {}", (Object)e.getMessage(), (Object)e);
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

