/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.pingall;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.pingall.UrlType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Objects;

public class PingResultDto
implements Comparable<PingResultDto> {
    @Schema(description="The id of the own partner")
    private String ownPartnerId;
    @Schema(description="The id of the communication partner")
    private String communicationPartnerId;
    @Schema(description="The type of the used URL. PRIMARY or FALLBACK")
    private UrlType urlType;
    @Schema(description="The message Id of the sent PING.")
    private String pingMessageId;
    @Schema(description="The message Id of the response for the sent PING.")
    private String replyMessageId;
    @Schema(description="The time (yyyy-MM-dd'T'HH:mm:ss.SSS'Z') at which the PING was sent.")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date pingTime;
    @Schema(description="The time (yyyy-MM-dd'T'HH:mm:ss.SSS'Z') at which the response for the sent PING was received.")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date replyTime;
    @Schema(description="The time in milliseconds between sending the PING and receiving the response.")
    private Integer duration;
    @Schema(description="The text of the response.")
    private String resultText;
    @Schema(description="If the response is positive (true), otherwise (false).")
    private Boolean error;

    public String getOwnPartnerId() {
        return this.ownPartnerId;
    }

    public PingResultDto setOwnPartnerId(String ownPartnerId) {
        this.ownPartnerId = ownPartnerId;
        return this;
    }

    public String getCommunicationPartnerId() {
        return this.communicationPartnerId;
    }

    public PingResultDto setCommunicationPartnerId(String communicationPartnerId) {
        this.communicationPartnerId = communicationPartnerId;
        return this;
    }

    public UrlType getUrlType() {
        return this.urlType;
    }

    public PingResultDto setUrlType(UrlType urlType) {
        this.urlType = urlType;
        return this;
    }

    public String getPingMessageId() {
        return this.pingMessageId;
    }

    public PingResultDto setPingMessageId(String pingMessageId) {
        this.pingMessageId = pingMessageId;
        return this;
    }

    public String getReplyMessageId() {
        return this.replyMessageId;
    }

    public PingResultDto setReplyMessageId(String replyMessageId) {
        this.replyMessageId = replyMessageId;
        return this;
    }

    public Date getPingTime() {
        return this.pingTime;
    }

    public PingResultDto setPingTime(Date pingTime) {
        this.pingTime = pingTime;
        return this;
    }

    public Date getReplyTime() {
        return this.replyTime;
    }

    public PingResultDto setReplyTime(Date replyTime) {
        this.replyTime = replyTime;
        return this;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public PingResultDto setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public String getResultText() {
        return this.resultText;
    }

    public PingResultDto setResultText(String resultText) {
        this.resultText = resultText;
        return this;
    }

    public Boolean getError() {
        return this.error;
    }

    public PingResultDto setError(Boolean error) {
        this.error = error;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PingResultDto that = (PingResultDto)o;
        return Objects.equals(this.ownPartnerId, that.ownPartnerId) && Objects.equals(this.communicationPartnerId, that.communicationPartnerId) && this.urlType == that.urlType && Objects.equals(this.pingMessageId, that.pingMessageId) && Objects.equals(this.replyMessageId, that.replyMessageId) && Objects.equals(this.pingTime, that.pingTime) && Objects.equals(this.replyTime, that.replyTime) && Objects.equals(this.duration, that.duration) && Objects.equals(this.resultText, that.resultText) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ownPartnerId, this.communicationPartnerId, this.urlType, this.pingMessageId, this.replyMessageId, this.pingTime, this.replyTime, this.duration, this.resultText, this.error});
    }

    @Override
    public int compareTo(PingResultDto pingResultDto) {
        int result = this.ownPartnerId.compareTo(pingResultDto.ownPartnerId);
        if (result == 0) {
            result = this.communicationPartnerId.compareTo(pingResultDto.communicationPartnerId);
        }
        if (result == 0) {
            result = this.getUrlType().compareTo(pingResultDto.getUrlType());
        }
        return result;
    }
}

