/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.pingall;

import de.ponton.xmlpipe.rest.pingall.PingResultDto;
import de.ponton.xmlpipe.rest.pingall.UrlType;
import de.pontonconsulting.xmlpipe.adapter.pingall.PingAllThread;
import de.pontonconsulting.xmlpipe.cluster.GlobalTaskManager;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.database.GlobalTaskType;
import io.swagger.v3.oas.annotations.Operation;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pingAll"})
@Validated
public class PingAllController {
    private static final String DOCUMENTATION_TAG_PING_ALL = "PingAll";
    private final PingAllThread pingAllThread;
    private final Profiles profiles;
    private final GlobalTaskManager globalTaskManager;

    public PingAllController(PingAllThread pingAllThread, Profiles profiles, GlobalTaskManager globalTaskManager) {
        this.pingAllThread = pingAllThread;
        this.profiles = profiles;
        this.globalTaskManager = globalTaskManager;
    }

    @GetMapping(value={"/result"})
    @Operation(summary="Get current PingAll result.", description="permission:PING_ALL_RESULT_GET<br><br>Get current PingAll result as a list of single ping results.", tags={"PingAll"})
    @Secured(value={"PING_ALL_RESULT_GET"})
    public ResponseEntity<SortedSet<PingResultDto>> getPingResults() {
        TreeSet pingResultDtos = new TreeSet();
        this.pingAllThread.getPingResults().forEach((key, pingResult) -> {
            try {
                pingResultDtos.add(new PingResultDto().setOwnPartnerId(this.profiles.getProfileForInternalId(pingResult.getSenderId(), true).getLocalId()).setCommunicationPartnerId(this.profiles.getProfileForInternalId(pingResult.getReceiverId(), true).getLocalId()).setUrlType(pingResult != null && "fallback".equals(pingResult.getUrlType()) ? UrlType.FALLBACK : UrlType.PRIMARY).setPingMessageId(pingResult.getPingMessageId()).setReplyMessageId(pingResult.getReplyMessageId()).setPingTime(pingResult.getPingTime()).setReplyTime(pingResult.getReplyTime()).setDuration(pingResult.getDuration()).setError(pingResult.isError()).setResultText(pingResult.getDescription()));
            }
            catch (ProfileException e) {
                throw new RuntimeException(e);
            }
        });
        return ResponseEntity.ok(pingResultDtos);
    }

    @PostMapping(value={"/sendPingsNow"})
    @Secured(value={"PING_ALL_SEND_PINGS_NOW_POST"})
    @Operation(summary="Send PINGs immediately.", description="permission:PING_ALL_SEND_PINGS_NOW_POST<br><br>Send PINGs immediately and ignore the set PingAll interval.", tags={"PingAll"})
    public ResponseEntity<Void> sendPingsNow() {
        this.globalTaskManager.scheduleManualExecution(GlobalTaskType.PING_ALL);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/pendingPings"})
    @Secured(value={"PING_ALL_PENDING_PINGS_GET"})
    @Operation(summary="Get number of pending PINGs. ", description="permission:PING_ALL_PENDING_PINGS_GET<br><br>Get number of pending PINGs.", tags={"PingAll"})
    public ResponseEntity<Integer> getNumberOfPendingPings() {
        return ResponseEntity.ok((Object)this.pingAllThread.getPendingPings());
    }
}

