/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagemulticastrule;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastRule;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastRuleDto;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageTypeModel;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class MessageMulticastRuleDtoFactory
implements IDtoFactory<MessageMulticastRuleDto, MessageMulticastRule> {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + MessageMulticastRuleDtoFactory.class.getName()));
    private final SchemataConfig schemataConfig;

    public MessageMulticastRuleDtoFactory(SchemataConfig schemataConfig) {
        this.schemataConfig = schemataConfig;
    }

    @Override
    public MessageMulticastRuleDto create(MessageMulticastRule valueObject) {
        ArrayList<String> messageTypeIds = new ArrayList<String>();
        for (MessageTypeModel messageTypeModel : valueObject.getMessageTypes()) {
            String schemaSet = messageTypeModel.getSchemaSet();
            String messageType = messageTypeModel.getMessageType();
            String messageVersion = messageTypeModel.getMessageVersion();
            Optional.ofNullable(this.schemataConfig.getSchemaBySetTypeVersion(schemaSet, messageType, messageVersion)).ifPresentOrElse(schemaData -> messageTypeIds.add(schemaData.getId()), () -> LOG.warn("No message type found for schemaSet '{}', messageType '{}' and messageVersion '{}'.", (Object)schemaSet, (Object)messageType, (Object)messageVersion));
        }
        return new MessageMulticastRuleDto().setMessageTypeIds(messageTypeIds).setReceiverBackendIds(valueObject.getReceiverBackendIds()).setSenderBackendIds(valueObject.getSenderBackendIds()).setCopyReceiverBackendIds(valueObject.getCopyReceiverBackendIds());
    }

    @Override
    public MessageMulticastRule parse(MessageMulticastRuleDto valueObject) {
        ArrayList<MessageTypeModel> messageTypes = new ArrayList<MessageTypeModel>();
        for (String messageTypeId : valueObject.getMessageTypeIds()) {
            SchemaData schemaData = this.schemataConfig.findSchemaDataById(messageTypeId);
            if (schemaData == null) {
                throw new IllegalArgumentException("No message type found for id '" + messageTypeId + "'.");
            }
            messageTypes.add(new MessageTypeModel().setSchemaSet(schemaData.getSchemaSetName()).setMessageType(schemaData.getMessageType()).setMessageVersion(schemaData.getMessageVersion()));
        }
        return new MessageMulticastRule().setMessageTypes(messageTypes).setReceiverBackendIds(valueObject.getReceiverBackendIds()).setSenderBackendIds(valueObject.getSenderBackendIds()).setCopyReceiverBackendIds(valueObject.getCopyReceiverBackendIds());
    }
}

