/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagemonitor;

import de.ponton.xmlpipe.rest.messagemonitor.MessageArchiveStatus;
import de.ponton.xmlpipe.rest.messagemonitor.MessageCategory;
import de.ponton.xmlpipe.rest.messagemonitor.MessageDto;
import de.ponton.xmlpipe.rest.messagemonitor.MessageFilterDto;
import de.ponton.xmlpipe.rest.messagemonitor.MessageSearchResultDto;
import de.ponton.xmlpipe.rest.messagemonitor.MessageStatus;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.security.acegi.ClientRoleService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageMonitorService {
    private static final Log LOG = LogFactory.getFactory().getInstance("Messenger." + MessageMonitorService.class.getName());
    private final ClientRoleService clientRoleService;
    private final HibernateSessionFactory hibernateSessionFactory;
    private final int maxMessages;

    public MessageMonitorService(ClientRoleService clientRoleService, HibernateSessionFactory hibernateSessionFactory, IMessengerProperties messengerProperties) {
        this.clientRoleService = clientRoleService;
        this.hibernateSessionFactory = hibernateSessionFactory;
        this.maxMessages = Integer.parseInt(messengerProperties.getProperty("ponton.messenger.message_monitor.limit", "2000"));
    }

    public List<Predicate> preparePredicates(CriteriaBuilder cb, Root<Message> message, MessageFilterDto filter, Principal principal) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (principal != null) {
            ArrayList partnerWhitelistPredicates = new ArrayList();
            this.clientRoleService.getWhitelistedPartners(principal.getName()).forEach(partnerId -> {
                partnerWhitelistPredicates.add(cb.and((Expression)cb.equal((Expression)message.get("senderId"), partnerId), (Expression)cb.equal((Expression)message.get("inbound"), (Object)0)));
                partnerWhitelistPredicates.add(cb.and((Expression)cb.equal((Expression)message.get("receiverId"), partnerId), (Expression)cb.equal((Expression)message.get("inbound"), (Object)1)));
            });
            if (!partnerWhitelistPredicates.isEmpty()) {
                predicates.add(cb.or(partnerWhitelistPredicates.toArray(new Predicate[0])));
            }
        }
        if (principal != null) {
            ArrayList adapterWhitelistPredicates = new ArrayList();
            this.clientRoleService.getWhitelistedAdapters(principal.getName()).forEach(adapterId -> adapterWhitelistPredicates.add(cb.equal((Expression)message.get("adapterId"), adapterId)));
            if (!adapterWhitelistPredicates.isEmpty()) {
                predicates.add(cb.or(adapterWhitelistPredicates.toArray(new Predicate[0])));
            }
        }
        if (filter.getLogInfo() != null) {
            if (filter.getLogInfo().contains("%")) {
                predicates.add(cb.like((Expression)message.get("loginfo"), filter.getLogInfo()));
            } else {
                predicates.add(cb.equal((Expression)message.get("loginfo"), (Object)filter.getLogInfo()));
            }
        }
        if (filter.getInboundStates() != null && filter.getOutboundStates() != null) {
            predicates.add(cb.or((Expression)this.getMessageStatusPredicate(filter.getInboundStates(), true, cb, message), (Expression)this.getMessageStatusPredicate(filter.getOutboundStates(), false, cb, message)));
        } else if (filter.getInboundStates() != null) {
            predicates.add(this.getMessageStatusPredicate(filter.getInboundStates(), true, cb, message));
        } else if (filter.getOutboundStates() != null) {
            predicates.add(this.getMessageStatusPredicate(filter.getOutboundStates(), false, cb, message));
        }
        if (filter.getMessageId() != null) {
            Join parentMessage = message.join("parent", JoinType.LEFT);
            if (filter.getMessageId().contains("%")) {
                predicates.add(cb.or((Expression)cb.like((Expression)message.get("messageId"), filter.getMessageId()), (Expression)cb.like((Expression)parentMessage.get("messageId"), filter.getMessageId())));
            } else {
                predicates.add(cb.or((Expression)cb.equal((Expression)message.get("messageId"), (Object)filter.getMessageId()), (Expression)cb.equal((Expression)parentMessage.get("messageId"), (Object)filter.getMessageId())));
            }
        }
        if (filter.getConversationId() != null) {
            Join conversation = message.join("conversation", JoinType.LEFT);
            if (filter.getConversationId().contains("%")) {
                predicates.add(cb.like((Expression)conversation.get("conversationId"), filter.getConversationId()));
            } else {
                predicates.add(cb.equal((Expression)conversation.get("conversationId"), (Object)filter.getConversationId()));
            }
        }
        if (CollectionUtils.isNotEmpty(filter.getMessageCategories())) {
            predicates.add(this.getMessageCategoriesPredicate(filter.getMessageCategories(), cb, message));
        }
        if (CollectionUtils.isNotEmpty(filter.getAdapterIds())) {
            ArrayList orPredicates = new ArrayList();
            filter.getAdapterIds().forEach(adapterId -> {
                orPredicates.add(cb.equal((Expression)message.get("adapterId"), adapterId));
                orPredicates.add(cb.like((Expression)message.get("adapterId"), adapterId + "\t%"));
            });
            predicates.add(cb.or(orPredicates.toArray(new Predicate[0])));
        }
        if (CollectionUtils.isNotEmpty(filter.getMessageTypes())) {
            predicates.add(message.get("messageType").in(filter.getMessageTypes()));
        }
        if (CollectionUtils.isNotEmpty(filter.getSchemaSets())) {
            predicates.add(message.get("schemaSet").in(filter.getSchemaSets()));
        }
        if (CollectionUtils.isNotEmpty(filter.getLocalPartnerIds())) {
            predicates.add(cb.or((Expression)message.get("senderId").in(filter.getLocalPartnerIds()), (Expression)message.get("receiverId").in(filter.getLocalPartnerIds())));
        }
        if (CollectionUtils.isNotEmpty(filter.getRemotePartnerIds())) {
            predicates.add(cb.or((Expression)message.get("senderId").in(filter.getRemotePartnerIds()), (Expression)message.get("receiverId").in(filter.getRemotePartnerIds())));
        }
        if (filter.getFromDate() != null) {
            predicates.add(cb.ge((Expression)message.get("messageTime"), (Number)filter.getFromDate().getTime()));
        }
        if (filter.getToDate() != null) {
            predicates.add(cb.le((Expression)message.get("messageTime"), (Number)filter.getToDate().getTime()));
        }
        if (CollectionUtils.isNotEmpty(filter.getArchiveStatus())) {
            ArrayList daoStates = new ArrayList();
            List<MessageArchiveStatus> states = filter.getArchiveStatus();
            states.forEach(s -> daoStates.add(s.getDbValue()));
            predicates.add(message.get("archiveStatus").in(daoStates));
        }
        return predicates;
    }

    private Predicate getMessageStatusPredicate(List<MessageStatus> states, boolean isInbound, CriteriaBuilder cb, Root<Message> root) {
        if (states.isEmpty()) {
            return cb.equal((Expression)root.get("inbound"), (Object)(isInbound ? 0 : 1));
        }
        ArrayList daoStates = new ArrayList();
        states.forEach(s -> daoStates.add(s.getDbValue()));
        return cb.and((Expression)root.get("status").in(daoStates), (Expression)cb.equal((Expression)root.get("inbound"), (Object)(isInbound ? 1 : 0)));
    }

    private Predicate getMessageCategoriesPredicate(List<MessageCategory> messageCategories, CriteriaBuilder cb, Root<Message> messageRoot) {
        ArrayList orList = new ArrayList();
        messageCategories.forEach(messageCategory -> {
            switch (messageCategory) {
                case SIGNAL: {
                    orList.add(cb.equal((Expression)messageRoot.get("schemaSet"), (Object)"ponton"));
                    break;
                }
                case TEST: {
                    orList.add(cb.and((Expression)cb.equal((Expression)messageRoot.get("testflag"), (Object)1), (Expression)cb.notEqual((Expression)messageRoot.get("schemaSet"), (Object)"ponton")));
                    break;
                }
                case PRODUCTION: {
                    orList.add(cb.and((Expression)cb.equal((Expression)messageRoot.get("testflag"), (Object)0), (Expression)cb.notEqual((Expression)messageRoot.get("schemaSet"), (Object)"ponton")));
                    break;
                }
                default: {
                    LOG.warn((Object)String.format("Received unknown MessageStatus: %s", messageCategory));
                }
            }
        });
        return cb.or(orList.toArray(new Predicate[0]));
    }

    public MessageSearchResultDto findMessages(MessageFilterDto filter, Principal principal) {
        MessageSearchResultDto result = new MessageSearchResultDto();
        try (EntityManager entityManager = this.hibernateSessionFactory.createNewEntityManager();){
            int maxCount;
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(Message.class);
            Root message = criteriaQuery.from(Message.class);
            criteriaQuery.where(this.preparePredicates(cb, (Root<Message>)message, filter, principal).toArray(new Predicate[0]));
            criteriaQuery.select((Selection)message);
            criteriaQuery.orderBy(new Order[]{cb.desc((Expression)message.get("messageTime"))});
            TypedQuery query = entityManager.createQuery(criteriaQuery);
            query.setMaxResults(this.maxMessages);
            List messages = query.getResultList();
            int count = messages.size();
            if (count == this.maxMessages) {
                CriteriaQuery countQuery = cb.createQuery(Long.class);
                Root countMessage = countQuery.from(Message.class);
                countQuery.select((Selection)cb.count((Expression)countMessage));
                countQuery.where(this.preparePredicates(cb, (Root<Message>)countMessage, filter, principal).toArray(new Predicate[0]));
                Long realCount = (Long)entityManager.createQuery(countQuery).getSingleResult();
                maxCount = realCount.intValue();
            } else {
                maxCount = count;
            }
            result.setTotalResultCount(maxCount);
            ArrayList<MessageDto> messageList = new ArrayList<MessageDto>();
            messages.forEach(dbMessage -> messageList.add(this.createMessageDto((Message)dbMessage)));
            result.setMessages(messageList);
            entityManager.clear();
        }
        catch (Exception e) {
            LOG.error((Object)(String.valueOf(e.getClass()) + " while searching for messages: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        return result;
    }

    private MessageDto createMessageDto(Message message) {
        return new MessageDto().setId(message.getId()).setInbound(message.getInbound() == 1).setStatus(this.getMessageStatus(message.getStatus())).setTest(message.getTestflag() != null && message.getTestflag() == 1).setCreationTime(this.getDate(message.getCreationTime())).setRegistrationTime(this.getDate(message.getMessageTime())).setSenderId(message.getSenderId()).setReceiverId(message.getReceiverId()).setMessageId(message.getMessageId()).setConversationId(message.getConversation() == null ? null : message.getConversation().getConversationId()).setSequenceNumber(message.getSequenceNumber() == null || message.getSequenceNumber() == -1L ? null : message.getSequenceNumber()).setSchemaSet(message.getSchemaSet()).setMessageType(message.getMessageType()).setTransmissionProtocol(message.getProtocol()).setPackager(message.getPackagingId()).setAdapterId(message.getAdapterId() != null ? message.getAdapterId().split("\t")[0] : null).setAckReceived(message.getAckReceived() != null && message.getAckReceived() == 1).setLogInfo(message.getLoginfo()).setClusterNodeId(message.getMessengerId()).setArchiveStatus(this.getMessageArchiveStatus(message.getArchiveStatus()));
    }

    private Date getDate(Long timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp);
    }

    private MessageStatus getMessageStatus(Integer status) {
        try {
            return MessageStatus.fromDBValue(status);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)e.getMessage());
            return null;
        }
    }

    private MessageArchiveStatus getMessageArchiveStatus(Integer archiveStatus) {
        try {
            return Objects.isNull(archiveStatus) ? MessageArchiveStatus.UNPROCESSED : MessageArchiveStatus.fromDBValue(archiveStatus);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)e.getMessage());
            return MessageArchiveStatus.fromDBValue(0);
        }
    }
}

