/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.message;

import de.ponton.xmlpipe.rest.message.MessageLogEvent;
import java.util.HashMap;
import java.util.Map;

public enum ProgressState {
    OUT_RECEIVED_FROM_ADAPTER,
    OUT_PROCESSED,
    OUT_PROCESSING_FAILED,
    OUT_TRANSMITTED,
    OUT_TRANSMITTING_FAILED,
    OUT_DELIVERED_TO_RECEIVER,
    OUT_DELIVERY_TO_RECEIVER_FAILED,
    IN_RECEIVED_FROM_LISTENER,
    IN_PROCESSED,
    IN_PROCESSING_FAILED,
    IN_DELIVERED_TO_ADAPTER,
    IN_DELIVERY_TO_ADAPTER_FAILED;

    private static final Map<MessageLogEvent, ProgressState> BY_LOG_EVENT_IN;
    private static final Map<MessageLogEvent, ProgressState> BY_LOG_EVENT_OUT;

    public static ProgressState getProgressStateFor(MessageLogEvent event, boolean isInbound) {
        if (isInbound) {
            return BY_LOG_EVENT_IN.get((Object)event);
        }
        return BY_LOG_EVENT_OUT.get((Object)event);
    }

    static {
        BY_LOG_EVENT_IN = new HashMap<MessageLogEvent, ProgressState>();
        BY_LOG_EVENT_OUT = new HashMap<MessageLogEvent, ProgressState>();
        BY_LOG_EVENT_OUT.put(MessageLogEvent.SEND_ERROR, OUT_TRANSMITTING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.COMPRESSION_ERROR, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.DECOMPRESSION_ERROR, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.SIGNATURE_ERROR, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.SIGNING_ERROR, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.DECRYPT_ERROR, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.ENCRYPT_ERROR, OUT_PROCESSED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.XML_VALIDATION_FAILED, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.XML_VALIDATION_FAILED, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.SENT_TO_ADAPTER_ERROR, IN_DELIVERY_TO_ADAPTER_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.RECEIVE_FROM_ADAPTER_ERROR, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.ACK_CONTAINS_ERROR, OUT_DELIVERY_TO_RECEIVER_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.XML_SIGNATURE_ERROR, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.XML_SIGNATURE_ERROR, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.PACKAGE_ERROR, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.XML_VALIDATION_DETAILS, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.XML_VALIDATION_DETAILS, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.ADD_INBOUND_QUEUE_ERROR, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.COULD_NOT_BE_PROCESSED, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.COULD_NOT_BE_PROCESSED, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.ADAPTER_REJECTED_MESSAGE, IN_DELIVERY_TO_ADAPTER_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.MESSAGE_HAD_LOCAL_TIMEOUT, OUT_TRANSMITTING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.MESSAGE_HAD_LOCAL_TIMEOUT, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.ADAPTER_DELIVERY_TIMEOUT, IN_DELIVERY_TO_ADAPTER_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.SMIME_SIGNATURE_VERIFICATION_FAILED, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.SMIME_SIGNATURE_ERROR, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.SMIME_DECRYPTION_ERROR, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.SMIME_ENCRYPTION_ERROR, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.SMIME_DECOMPRESSION_ERROR, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.SMIME_COMPRESSION_ERROR, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.UNEXPECTED_MESSAGE_PROCESSING_INTERRUPTION, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.UNEXPECTED_MESSAGE_PROCESSING_INTERRUPTION, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.XML_ENCRYPTION_ENCRYPT_ERROR, OUT_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.XML_ENCRYPTION_DECRYPT_ERROR, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_IN.put(MessageLogEvent.CONTENT_TRIGGER_ERROR, IN_PROCESSING_FAILED);
        BY_LOG_EVENT_OUT.put(MessageLogEvent.CONTENT_TRIGGER_ERROR, OUT_PROCESSING_FAILED);
    }
}

