/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public enum MessageLogEvent {
    SEPARATOR(-1),
    SEND_TRY(0),
    ACK_SEND_TRY(1),
    ACK_OK_CREATED(2),
    RULE_MATCH_FOR_ADAPTER_CHANGE(3),
    ACK_INFO(5),
    ADD_INBOUND_QUEUE(6),
    ACK_ERROR_CREATED(7),
    CHANGED_ADAPTER(8),
    VALIDATION_DISABLED(9),
    XML_MODIFICATION_DISABLED(10),
    ACK_TO_ADAPTER(59),
    RECEIVED(60),
    VALIDATED_OK(61),
    COMPRESSED_OK(62),
    SIGNED_OK(63),
    ENCRYPTED_OK(64),
    ACK_RECEIVED(66),
    TO_ADAPTER(67),
    FROM_ADAPTER(68),
    DECOMPRESSED(69),
    DECRYPTED(70),
    SIGNATURE_OK(71),
    XML_SIGNATURE_VERIFIED_OK(72),
    XML_SIGNATURE_CREATED_OK(73),
    SEND_OK(74),
    MESSAGE_CONTENT_MATCHED(76),
    ACK_SEND_OK(77),
    ARCHIVED(78),
    PACKAGE_OK(79),
    ACK_CONVERTED(80),
    CUSTOM_FILTER_OK(81),
    DELIVERYRESPONSE_FROM_ADAPTER(82),
    SMIME_SIGNATURE_VERIFIED_OK(83),
    SMIME_DECRYPTION_OK(85),
    SMIME_ENCRYPTION_OK(86),
    SMIME_DECOMPRESSION_OK(87),
    SMIME_COMPRESSION_OK(88),
    SMIME_SIGNATURE_CREATED_OK(84),
    ACK_IGNORED(89),
    XML_ENCRYPTION_ENCRYPTED_OK(90),
    XML_ENCRYPTION_DECRYPTED_OK(91),
    CREATED_STATUS_REQUEST_FOR_MSG(92),
    RECEIVED_STATUS_REQUEST_FOR_MSG(93),
    CREATED_STATUS_REQUEST(94),
    RECEIVED_STATUS_RESPONSE(95),
    RECEIVED_STATUS_REQUEST(96),
    CREATED_STATUS_RESPONSE(97),
    STATUS_RESPONSE_IGNORED(98),
    COMPLETE(100),
    INBOUND_COMPLETED(101),
    OUTBOUND_COMPLETED(102),
    ACK_INBOUND_COMPLETED(103),
    ACK_OUTBOUND_COMPLETED(104),
    XML_MODIFICATION(105),
    IGNORE_DUPLICATE(106),
    NO_VIRUS_FOUND(107),
    ACK_CONTAINS_WARNING(201),
    ADAPTER_NOT_CONTACTED_SINCE(203),
    CONTENT_TRIGGER_WAS_TRUE(204),
    CERT_INSTALLED(205),
    INTERNAL_ACK(206),
    CUSTOM_FILTER_WARNING(207),
    NO_ACK_EXPECTED(208),
    NO_REF_MESSAGE_FOUND(209),
    NO_STATUS_RESPONSE_EXPECTED(210),
    MESSAGE_HAS_TO_WAIT_FOR_SUCCESSFUL_DELIVERY_OF_PREVIOUS_MESSAGE(211),
    MESSAGE_MANUALLY_DELETED_FROM_QUEUE(212),
    VIRUS_SCANNER_COMMUNICATION_PROBLEM(213),
    MESSAGE_RESENT(214),
    ACK_COULD_NOT_BE_PROCESSED(215),
    MESSAGE_REQUEUE(216),
    INBOUND_MESSAGE_DUPLICATED(217),
    INBOUND_MESSAGE_DUPLICATED_FROM_MESSAGE(218),
    RECEIVE_ERROR(500),
    SEND_ERROR(501),
    COMPRESSION_ERROR(502),
    DECOMPRESSION_ERROR(503),
    SIGNATURE_ERROR(504),
    SIGNING_ERROR(505),
    DECRYPT_ERROR(506),
    ENCRYPT_ERROR(507),
    XML_VALIDATION_FAILED(508),
    FILE_NOT_FOUND(509),
    OPEN_ERROR(510),
    SAVE_ERROR(511),
    ACK_PARSE_ERROR(512),
    PARSE_ERROR(513),
    SENT_TO_ADAPTER_ERROR(514),
    RECEIVE_FROM_ADAPTER_ERROR(515),
    ACK_CONTAINS_ERROR(516),
    NOTIFICATION_CONTAINS_ERROR(517),
    RECEIVER_URL_INVALID_ERROR(518),
    MAX_RETRIES_ERROR(519),
    TRANSFER_ERROR(520),
    XML_SIGNATURE_ERROR(521),
    PACKAGE_ERROR(522),
    XML_VALIDATION_DETAILS(523),
    ACK_CONVERSION_PROBLEM(524),
    MESSAGE_NOT_FOUND(526),
    ADD_INBOUND_QUEUE_ERROR(525),
    COULD_NOT_BE_PROCESSED(527),
    ACK_NOT_EXPECTED_ERROR(528),
    CUSTOM_FILTER(529),
    ADAPTER_REJECTED_MESSAGE(530),
    MESSAGE_HAD_LOCAL_TIMEOUT(532),
    ADAPTER_DELIVERY_TIMEOUT(533),
    SMIME_SIGNATURE_VERIFICATION_FAILED(534),
    SMIME_SIGNATURE_ERROR(535),
    SMIME_DECRYPTION_ERROR(536),
    SMIME_ENCRYPTION_ERROR(537),
    SMIME_DECOMPRESSION_ERROR(538),
    SMIME_COMPRESSION_ERROR(539),
    UNEXPECTED_MESSAGE_PROCESSING_INTERRUPTION(540),
    XML_ENCRYPTION_ENCRYPT_ERROR(541),
    XML_ENCRYPTION_DECRYPT_ERROR(542),
    VIRUS_DETECTED_ERROR(543),
    CONTENT_TRIGGER_ERROR(544),
    ARCHIVING_ERROR(545);

    private static final Map<Integer, MessageLogEvent> BY_EVENT_ID;
    private final int eventId;

    public static MessageLogEvent ofEventId(int eventId) {
        return BY_EVENT_ID.get(eventId);
    }

    public static List<MessageLogEvent> ofEventIds(Integer ... eventIds) {
        ArrayList<MessageLogEvent> messageLogEvents = new ArrayList<MessageLogEvent>(eventIds.length);
        for (Integer eventId : eventIds) {
            if (eventId == null) continue;
            Optional.ofNullable(MessageLogEvent.ofEventId(eventId)).ifPresent(messageLogEvent -> messageLogEvents.add((MessageLogEvent)((Object)messageLogEvent)));
        }
        return messageLogEvents;
    }

    private MessageLogEvent(int eventId) {
        this.eventId = eventId;
    }

    public Integer getEventId() {
        return this.eventId;
    }

    static {
        BY_EVENT_ID = new HashMap<Integer, MessageLogEvent>();
        for (MessageLogEvent event : MessageLogEvent.values()) {
            MessageLogEvent duplicate = BY_EVENT_ID.put(event.eventId, event);
            if (duplicate == null) continue;
            throw new RuntimeException(String.valueOf((Object)event) + " and " + String.valueOf((Object)duplicate) + " use the same value " + event.eventId);
        }
        int expectedLength = 119;
        if (MessageLogEvent.values().length != 119) {
            throw new RuntimeException("expected 119 but got " + MessageLogEvent.values().length);
        }
    }
}

