/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.message;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.message.MessageLogEvent;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Describes message log entry of an exchanged message")
public class MessageLogDto {
    @NotNull
    @Schema(description="Timestamp of the message log")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date timestamp;
    @NotNull
    @Schema(description="Event of the message log")
    private MessageLogEvent event;
    @Schema(description="Additional text of the message log")
    @TrimmedField
    private String additionalText;
    @Schema(description="Technical ID of the referenced message")
    private Long referencedMessageId;

    public Date getTimestamp() {
        return this.timestamp;
    }

    public MessageLogDto setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public MessageLogEvent getEvent() {
        return this.event;
    }

    public MessageLogDto setEvent(MessageLogEvent event) {
        this.event = event;
        return this;
    }

    public String getAdditionalText() {
        return this.additionalText;
    }

    public MessageLogDto setAdditionalText(String additionalText) {
        this.additionalText = additionalText;
        return this;
    }

    public Long getReferencedMessageId() {
        return this.referencedMessageId;
    }

    public MessageLogDto setReferencedMessageId(Long referencedMessageId) {
        this.referencedMessageId = referencedMessageId;
        return this;
    }
}

