/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener;

import de.ponton.securelistener.administration.certs.Certificate;
import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.certificate.CertificateDtoFactory;
import de.ponton.xmlpipe.rest.cpp.certificate.ExportKeyPairDto;
import de.ponton.xmlpipe.rest.cpp.certificate.ImportCertificateDto;
import de.ponton.xmlpipe.rest.cpp.certificate.ImportKeyPairDto;
import de.ponton.xmlpipe.rest.listener.ListenerConfigurationDto;
import de.ponton.xmlpipe.rest.listener.ListenerConfigurationDtoFactory;
import de.ponton.xmlpipe.rest.listener.ListenerServerCertificateService;
import de.ponton.xmlpipe.rest.server.certificate.CreateServerCertificateRequestDto;
import de.ponton.xmlpipe.rest.server.certificate.ServerCertificateRequestDto;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import de.ponton.xmlpipe.rest.validation.X509CertificateConstraint;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.operator.OperatorCreationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/listener"})
@Validated
public class ListenerController {
    public static final String DOCUMENTATION_TAG = "Listener Configuration";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final ListenerConfig listenerConfig;
    private final ListenerConfigurationDtoFactory listenerConfigurationDtoFactory;
    private final ListenerServerCertificateService listenerServerCertificateService;
    private final CertificateDtoFactory certificateDtoFactory;
    private final CertificateUtility certificateUtility;

    public ListenerController(ListenerConfig listenerConfig, ListenerConfigurationDtoFactory listenerConfigurationDtoFactory, ListenerServerCertificateService listenerServerCertificateService, CertificateDtoFactory certificateDtoFactory, CertificateUtility certificateUtility) {
        this.listenerConfig = listenerConfig;
        this.listenerConfigurationDtoFactory = listenerConfigurationDtoFactory;
        this.listenerServerCertificateService = listenerServerCertificateService;
        this.certificateDtoFactory = certificateDtoFactory;
        this.certificateUtility = certificateUtility;
    }

    @GetMapping(value={"/configuration"})
    @Operation(summary="Get the listener configuration", description="permission:LISTENER_CONFIGURATION_GET<br><br>Returns the listener configuration", tags={"Listener Configuration"})
    @Secured(value={"LISTENER_CONFIGURATION_GET"})
    public ResponseEntity<ListenerConfigurationDto> getListenerConfiguration() throws ListenerConfigException {
        return ResponseEntity.ok((Object)this.listenerConfigurationDtoFactory.create(this.listenerConfig.getListenerConfiguration()));
    }

    @PutMapping(value={"/configuration"})
    @Operation(summary="Update the listener configuration", description="permission:LISTENER_CONFIGURATION_PUT<br><br>The passed configuration will be updated on the listener.", tags={"Listener Configuration"})
    @Validated(value={ValidationGroup.Update.class})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"LISTENER_CONFIGURATION_PUT"})
    public ResponseEntity<Void> updateListenerConfiguration(@RequestBody @Valid ListenerConfigurationDto configurationDto, Principal principal) throws ListenerConfigException {
        this.listenerConfig.updateListenerConfiguration(this.listenerConfigurationDtoFactory.parse(configurationDto), principal.getName());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @GetMapping(value={"/ip"})
    @Operation(summary="List of ip addresses of listener", description="permission:LISTENER_CONFIGURATION_IP_GET<br><br>Returns a list of available ip addresses on the listener machine", tags={"Listener Configuration"})
    @Secured(value={"LISTENER_CONFIGURATION_IP_GET"})
    public ResponseEntity<List<String>> getIpAddresses() throws ListenerConfigException {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body(this.listenerConfig.getIpAddresses());
    }

    @GetMapping(value={"/certificate/{id}"})
    @Operation(summary="Get a single listener server certificate", description="permission:LISTENER_CERTIFICATE_GET<br><br>Returns the current server certificate on the listener machine", tags={"Listener Configuration"})
    @Secured(value={"LISTENER_CERTIFICATE_GET"})
    public ResponseEntity<CertificateDto> getServerCertificate(@PathVariable String id) throws ListenerConfigException, InstallCertException, CertificateException, KeyStoreException, NoSuchProviderException {
        Certificate serverCertificate = this.listenerConfig.getServerCertificate(id);
        return serverCertificate == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)this.certificateDtoFactory.create(this.certificateUtility.getX509Certificate(serverCertificate.getCertificate())).setId(id));
    }

    @GetMapping(value={"/certificate"})
    @Operation(summary="Get all listener server certificates", description="permission:LISTENER_CERTIFICATE_GET<br><br>Returns all server certificates on the listener machine", tags={"Listener Configuration"})
    @Secured(value={"LISTENER_CERTIFICATE_GET"})
    public ResponseEntity<List<CertificateDto>> getServerCertificates() throws ListenerConfigException, InstallCertException, CertificateException, NoSuchProviderException {
        ArrayList<CertificateDto> result = new ArrayList<CertificateDto>();
        for (String alias : this.listenerConfig.listServerCertificates()) {
            result.add(this.certificateDtoFactory.create(this.certificateUtility.getX509Certificate(this.listenerConfig.getServerCertificate(alias).getCertificate())).setId(alias));
        }
        return ResponseEntity.ok(result);
    }

    @PostMapping(value={"/certificate"})
    @Operation(summary="Import listener  certificate", description="permission:LISTENER_CERTIFICATE_POST<br><br>Import the passed listener certificate.", tags={"Listener Configuration"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Secured(value={"LISTENER_CERTIFICATE_POST"})
    public ResponseEntity<CertificateDto> importCertificate(@Valid @RequestBody ImportCertificateDto importCertificateDto) throws ListenerConfigException, InstallCertException, CertificateException, NoSuchProviderException {
        String certificateId = this.listenerServerCertificateService.installCertificate(importCertificateDto.getCertificateBase64(), importCertificateDto.getPassword());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.certificateDtoFactory.create(this.certificateUtility.getX509Certificate(importCertificateDto.getCertificateBase64())).setId(certificateId));
    }

    @DeleteMapping(value={"/certificate/{id}"})
    @Secured(value={"LISTENER_CERTIFICATE_DELETE"})
    @Operation(summary="Delete a listener server certificate", description="permission:LISTENER_CERTIFICATE_DELETE<br><br>Delete a listener certificate identified by the passed id", tags={"Listener Configuration"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteCertificate(@PathVariable String id) throws ListenerConfigException {
        this.listenerServerCertificateService.deleteCertificate(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Get Listener Server SSL PKCS12 for the given ID", description="permission:LISTENER_KEYPAIR_GET<br><br>Get Listener Server SSL certificate and PrivateKey from a PKCS12 keystore", tags={"Listener Configuration"})
    @GetMapping(value={"/keypair/{id}"})
    @Secured(value={"LISTENER_KEYPAIR_GET"})
    public ResponseEntity<ExportKeyPairDto> getKeyPair(@PathVariable String id, @RequestParam String password) throws GeneralSecurityException, IOException, ListenerConfigException {
        return ResponseEntity.ok((Object)new ExportKeyPairDto().setKeystore(new String(this.listenerServerCertificateService.exportKeystore(id, password))));
    }

    @Operation(summary="Install Listener Server SSL PKCS12", description="permission:LISTENER_KEYPAIR_POST<br><br>Install Listener Server SSL certificate and PrivateKey from a PKCS12 keystore", tags={"Listener Configuration"})
    @PostMapping(value={"/keypair"})
    @Secured(value={"LISTENER_KEYPAIR_POST"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<CertificateDto> postCertificate(@Valid @RequestBody ImportKeyPairDto importKeyPairDto) throws Exception {
        String certificateId = this.listenerServerCertificateService.installKeystore(importKeyPairDto.getKeystore(), importKeyPairDto.getPassword());
        Certificate serverCertificate = this.listenerConfig.getServerCertificate(certificateId);
        if (serverCertificate == null) {
            throw new ListenerConfigException(-1, "Certificate not found after installation.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.certificateDtoFactory.create(this.certificateUtility.getX509Certificate(serverCertificate.getCertificate())).setId(certificateId));
    }

    @PostMapping(value={"/certificateRequest"})
    @Secured(value={"LISTENER_CERTIFICATE_REQUEST_POST"})
    @Operation(summary="Server Certificate Sign Request", description="permission:LISTENER_CERTIFICATE_REQUEST_POST<br><br>Create a Server Certificate Sign Request", tags={"Listener Configuration"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<ServerCertificateRequestDto> createCertificateRequest(@RequestBody @Valid CreateServerCertificateRequestDto createServerCertificateRequestDto) throws InstallCertException, GeneralSecurityException, IOException, OperatorCreationException, ListenerConfigException {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.listenerServerCertificateService.createListenerCertRequest(createServerCertificateRequestDto));
    }

    @Operation(summary="Get all Listener Server CA Certificates", description="permission:LISTENER_SERVER_CA_CERTIFICATE_GET<br><br>Returns a list of all Listener Server CA Certificates", tags={"Listener Configuration"})
    @GetMapping(value={"/serverCaCertificate"})
    @Secured(value={"LISTENER_SERVER_CA_CERTIFICATE_GET"})
    public ResponseEntity<List<CertificateDto>> getAllServerCertificateAuthority() throws ListenerConfigException, InstallCertException, CertificateException, NoSuchProviderException {
        ArrayList<CertificateDto> result = new ArrayList<CertificateDto>();
        for (String alias : this.listenerConfig.listServerCACertificates()) {
            result.add(this.certificateDtoFactory.create(this.certificateUtility.getX509Certificate(this.listenerConfig.getServerCACertificate(alias).getCertificate())).setId(Base64.getEncoder().encodeToString(alias.getBytes(StandardCharsets.UTF_8))));
        }
        return ResponseEntity.ok(result);
    }

    @Operation(summary="Get a single Listener Server CA Certificates", description="permission:LISTENER_SERVER_CA_CERTIFICATE_GET<br><br>The id is the BASE64 encoded alias", tags={"Listener Configuration"})
    @GetMapping(value={"/serverCaCertificate/{id}"})
    @Secured(value={"LISTENER_SERVER_CA_CERTIFICATE_GET"})
    public ResponseEntity<CertificateDto> getServerCertificateAuthority(@PathVariable String id) throws ListenerConfigException, InstallCertException, CertificateException, NoSuchProviderException {
        String alias = new String(Base64.getDecoder().decode(id));
        Certificate serverCACertificate = this.listenerConfig.getServerCACertificate(alias);
        return serverCACertificate == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)this.certificateDtoFactory.create(this.certificateUtility.getX509Certificate(serverCACertificate.getCertificate())).setId(id));
    }

    @Operation(summary="Post a Listener Server CA Certificate", description="permission:LISTENER_SERVER_CA_CERTIFICATE_POST<br><br>Returns the stored Server CA Certificate, the Id is the BASE64 encoded alias", tags={"Listener Configuration"})
    @Validated(value={ValidationGroup.Create.class})
    @PostMapping(value={"/serverCaCertificate"})
    @Secured(value={"LISTENER_SERVER_CA_CERTIFICATE_POST"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<CertificateDto> postServerCertificateAuthority(@Valid @X509CertificateConstraint @RequestBody String certificate) throws CertificateException, InstallCertException, NoSuchProviderException, ListenerConfigException, KeyStoreException {
        X509Certificate x509Certificate = this.certificateUtility.getX509Certificate(certificate);
        String alias = this.certificateUtility.buildAliasForCA(x509Certificate);
        if (this.listenerConfig.listServerCACertificates().contains(alias)) {
            this.listenerConfig.deleteServerCACertificate(alias);
        }
        this.listenerConfig.installServerCACertificate(new Certificate(x509Certificate.getEncoded()), alias);
        this.listenerConfig.restartServices();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.certificateDtoFactory.create(x509Certificate).setId(Base64.getEncoder().encodeToString(alias.getBytes(StandardCharsets.UTF_8))));
    }

    @Operation(summary="Delete a Listener Server CA Certificate", description="permission:LISTENER_SERVER_CA_CERTIFICATE_DELETE<br><br>The id is the BASE64 encoded alias", tags={"Listener Configuration"})
    @Validated(value={ValidationGroup.Update.class})
    @DeleteMapping(value={"/serverCaCertificate/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"LISTENER_SERVER_CA_CERTIFICATE_DELETE"})
    public ResponseEntity<Void> deleteServerCertificateAuthority(@PathVariable String id) throws ListenerConfigException, KeyStoreException {
        this.listenerConfig.deleteServerCACertificate(new String(Base64.getDecoder().decode(id)));
        this.listenerConfig.restartServices();
        return ResponseEntity.noContent().build();
    }
}

