/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.hotfolder;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.hotfolder.HotFolderDto;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderCfg;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderConfiguration;
import de.pontonconsulting.xmlpipe.config.hotfolder.FileProcessing;
import jakarta.xml.bind.JAXBException;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class HotFolderDtoFactory
implements IDtoFactory<HotFolderDto, HotFolderCfg> {
    private final HotFolderConfiguration hotFolderConfiguration;

    public HotFolderDtoFactory(HotFolderConfiguration hotFolderConfiguration) {
        this.hotFolderConfiguration = hotFolderConfiguration;
    }

    @Override
    public HotFolderDto create(HotFolderCfg valueObject) {
        try {
            return new HotFolderDto().setAcceptedFileExtensions(valueObject.getAcceptedFileExtensions()).setXmlAcknowledgementEnabled(valueObject.isERPAcknowledgementEnabled()).setXmlAcknowledgementFolder(valueObject.getERPInbox()).setFailedFolder(valueObject.getFailed()).setFileNamePattern(valueObject.getFileNamePattern()).setMinFileAge(valueObject.getMinFileAge()).setNumberOfReceivingThreads(valueObject.getNumberOfReceivingThreads()).setNumberOfSendingThreads(valueObject.getNumberOfSendingThreads()).setSaveWithBackEndEnvelope(valueObject.getSaveWithBackEndEnvelope()).setScanInterval(valueObject.getScanInterval()).setSenderBackendId(valueObject.getSenderLocalID()).setSupportsAttachments(valueObject.getSupportsAttachments()).setUsePartnerSubFolders(valueObject.getUsePartnerSubfolders()).setWorkFolder(valueObject.getWork()).setAdapterId(valueObject.getAdapterID()).setInboxFolder(valueObject.getInbox()).setOutboxFolder(valueObject.getOutbox()).setFileProcessing(FileProcessing.fromValue((String)valueObject.getFileProcessing()));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HotFolderCfg parse(HotFolderDto valueObject) {
        try {
            HotFolderCfg hotFolder = this.hotFolderConfiguration.getHotFolder(valueObject.getAdapterId());
            hotFolder.setAcceptedFileExtension(valueObject.getAcceptedFileExtensions());
            hotFolder.setERPAcknowledgementEnabled(Optional.ofNullable(valueObject.isXmlAcknowledgementEnabled()).orElse(false));
            hotFolder.setERPInbox(valueObject.getXmlAcknowledgementFolder());
            hotFolder.setFileNamePattern(valueObject.getFileNamePattern());
            hotFolder.setMinFileAge(valueObject.getMinFileAge());
            hotFolder.setNumberOfReceivingThreads(Optional.ofNullable(valueObject.getNumberOfReceivingThreads()).orElse(0));
            hotFolder.setNumberOfSendingThreads(Optional.ofNullable(valueObject.getNumberOfSendingThreads()).orElse(0));
            hotFolder.setSaveWithBackEndEnvelope(Optional.ofNullable(valueObject.isSaveWithBackEndEnvelope()).orElse(false));
            hotFolder.setScanInterval(Optional.ofNullable(valueObject.getScanInterval()).orElse(0L));
            hotFolder.setSenderLocalID(valueObject.getSenderBackendId());
            hotFolder.setSupportsAttachments(Optional.ofNullable(valueObject.isSupportsAttachments()).orElse(false));
            hotFolder.setUsePartnerSubfolders(Optional.ofNullable(valueObject.isUsePartnerSubFolders()).orElse(false));
            hotFolder.setWork(valueObject.getWorkFolder());
            hotFolder.setAdapterID(valueObject.getAdapterId());
            hotFolder.setInbox(valueObject.getInboxFolder());
            hotFolder.setOutbox(valueObject.getOutboxFolder());
            hotFolder.setFailed(valueObject.getFailedFolder());
            hotFolder.setFileProcessing(valueObject.getFileProcessing().value());
            return hotFolder;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

