/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.exception;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExceptionDto {
    private final List<Violation> violations = new ArrayList<Violation>();
    @TrimmedField
    private String exception;
    @TrimmedField
    private String errorMessage;
    private final Map<String, Object> errorMessageParameter = new HashMap<String, Object>();
    @TrimmedField
    private String errorKey;

    public String getException() {
        return this.exception;
    }

    public ExceptionDto setException(String exception) {
        this.exception = exception;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ExceptionDto setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public ExceptionDto addErrorMessageParameter(String key, Object value) {
        this.errorMessageParameter.put(key, value);
        return this;
    }

    public Map<String, Object> getErrorMessageParameter() {
        return Collections.unmodifiableMap(this.errorMessageParameter);
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public ExceptionDto setErrorKey(String errorKey) {
        this.errorKey = errorKey;
        return this;
    }

    public ExceptionDto addViolation(ConstraintViolation<?> violation) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(violation.getConstraintDescriptor().getAttributes());
        List.of("groups", "message", "payload").forEach(attributes::remove);
        Object invalidValue = EnumSet.of(ElementKind.CONTAINER_ELEMENT, ElementKind.CROSS_PARAMETER, ElementKind.PARAMETER, ElementKind.PROPERTY).contains(((Path.Node)violation.getPropertyPath().iterator().next()).getKind()) ? violation.getInvalidValue() : "N/A";
        this.violations.add(new Violation(this.getLastElement(violation.getPropertyPath()), invalidValue, violation.getMessage(), violation.getMessageTemplate().replace("{", "").replace("}", ""), attributes));
        return this;
    }

    public ExceptionDto addViolation(Violation violation) {
        this.violations.add(violation);
        return this;
    }

    private String getLastElement(Path path) {
        Path.Node lastNode = null;
        Path.Node parentNode = null;
        for (Path.Node node : path) {
            parentNode = lastNode;
            lastNode = node;
        }
        if (lastNode != null) {
            if (lastNode.getKind() == ElementKind.CONTAINER_ELEMENT) {
                return parentNode != null ? String.format("%s[%d]", path, lastNode.getIndex()) : path.toString();
            }
            return path.toString();
        }
        return "unknown";
    }

    public List<Violation> getViolations() {
        return Collections.unmodifiableList(this.violations);
    }

    public static class Violation {
        private final String fieldName;
        private final Object value;
        private final String message;
        private final String errorKey;
        private final Map<String, Object> constraintValues;

        public Violation(String fieldName, Object value, String message, String errorKey, Map<String, Object> constraintValues) {
            this.fieldName = fieldName;
            this.value = value;
            this.message = message;
            this.errorKey = errorKey;
            this.constraintValues = constraintValues;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getValue() {
            return this.value;
        }

        public String getMessage() {
            return this.message;
        }

        public String getErrorKey() {
            return this.errorKey;
        }

        public Map<String, Object> getConstraintValues() {
            return this.constraintValues;
        }
    }
}

