/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.validation;

import de.ponton.xmlpipe.rest.cpp.validation.RequiredFieldForLocalPartner;
import de.ponton.xmlpipe.rest.cpp.validation.RequiredFieldsForLocalPartnerConstraint;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.validation.CrossParameterValidator;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
public class RequiredFieldsForLocalPartnerValidator
implements ConstraintValidator<RequiredFieldsForLocalPartnerConstraint, Object[]> {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final CrossParameterValidator crossParameterValidator;
    private final Profiles profiles;
    private String validationMessage;

    public RequiredFieldsForLocalPartnerValidator(CrossParameterValidator crossParameterValidator, Profiles profiles) {
        this.crossParameterValidator = crossParameterValidator;
        this.profiles = profiles;
    }

    private CppPartner resolveResource(String partnerId) {
        try {
            return this.profiles.getProfileForLocalId(partnerId, true);
        }
        catch (ProfileException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    public void initialize(RequiredFieldsForLocalPartnerConstraint constraintAnnotation) {
        this.validationMessage = constraintAnnotation.message();
    }

    public boolean isValid(Object[] value, ConstraintValidatorContext context) {
        return this.crossParameterValidator.validate(value, context, this.validationMessage, this::validateField, RequiredFieldForLocalPartner.class);
    }

    private boolean validateField(Field field, Object ... args) {
        CppPartner cppPartner = this.resolveResource(args[0].toString());
        Object dto = args[1];
        if (cppPartner.isLocal()) {
            try {
                Object fieldValue = field.get(dto);
                if (fieldValue == null) {
                    return false;
                }
                if (fieldValue instanceof String && ((String)fieldValue).trim().isEmpty()) {
                    return false;
                }
            }
            catch (IllegalAccessException e) {
                this.log.error("Field does not exist on class [field={}, class={}]", (Object)field.getName(), (Object)dto.getClass().getName());
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

