/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.validation;

import de.ponton.xmlpipe.rest.cpp.validation.PartnerType;
import de.ponton.xmlpipe.rest.cpp.validation.PartnerTypeConstraint;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;

@SupportedValidationTarget(value={ValidationTarget.ANNOTATED_ELEMENT})
public class PartnerTypeValidator
implements ConstraintValidator<PartnerTypeConstraint, String> {
    private final Profiles profiles;
    private PartnerType partnerType;

    public PartnerTypeValidator(Profiles profiles) {
        this.profiles = profiles;
    }

    public boolean isValid(String partnerId, ConstraintValidatorContext context) {
        try {
            CppPartner partner = this.profiles.getProfileForLocalId(partnerId, true);
            switch (this.partnerType) {
                case LOCAL: {
                    return partner.isLocal();
                }
                case REMOTE: {
                    return partner.isRemote();
                }
            }
            return true;
        }
        catch (ProfileException e) {
            return true;
        }
    }

    public void initialize(PartnerTypeConstraint constraintAnnotation) {
        this.partnerType = constraintAnnotation.value();
    }
}

