/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.validation;

import de.ponton.xmlpipe.rest.cpp.PartnerDto;
import de.ponton.xmlpipe.rest.cpp.PartnerDtoFactory;
import de.ponton.xmlpipe.rest.cpp.validation.ImmutablePartnerFieldConstraint;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.validation.CrossParameterValidator;
import de.ponton.xmlpipe.rest.validation.Immutable;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.reflect.Field;
import java.util.Objects;

@SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
public class ImmutablePartnerFieldValidator
implements ConstraintValidator<ImmutablePartnerFieldConstraint, Object[]> {
    private final Profiles profiles;
    private final CrossParameterValidator crossParameterValidator;
    private final PartnerDtoFactory partnerDtoFactory;
    private String message;

    public ImmutablePartnerFieldValidator(Profiles profiles, CrossParameterValidator crossParameterValidator, PartnerDtoFactory partnerDtoFactory) {
        this.profiles = profiles;
        this.crossParameterValidator = crossParameterValidator;
        this.partnerDtoFactory = partnerDtoFactory;
    }

    public void initialize(ImmutablePartnerFieldConstraint constraintAnnotation) {
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Object[] value, ConstraintValidatorContext context) {
        return this.crossParameterValidator.validate(value, context, this.message, this::validateField, Immutable.class);
    }

    private boolean validateField(Field field, Object ... args) {
        try {
            return Objects.equals(field.get(this.resolveResource(args[0].toString())), field.get(args[1]));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private PartnerDto resolveResource(String partnerId) {
        try {
            return this.partnerDtoFactory.create(this.profiles.getProfileForLocalId(partnerId, true));
        }
        catch (ProfileException e) {
            throw new ResourceNotFoundException(e);
        }
    }
}

