/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.maintenance;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.validation.EndDate;
import de.ponton.xmlpipe.rest.validation.StartDate;
import de.ponton.xmlpipe.rest.validation.ValidPeriodConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@ValidPeriodConstraint
@Schema(description="Defines a maintenance period for partners.")
public class MaintenancePeriodDto {
    @NotNull
    @StartDate
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    @Schema(description="The start date and time of the maintenance period.")
    private OffsetDateTime startDate;
    @NotNull
    @EndDate
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    @Schema(description="The end date and time of the maintenance period.")
    private OffsetDateTime endDate;

    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public MaintenancePeriodDto setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public MaintenancePeriodDto setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaintenancePeriodDto)) {
            return false;
        }
        MaintenancePeriodDto that = (MaintenancePeriodDto)o;
        return Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate);
    }

    public String toString() {
        return "MaintenancePeriodDto{startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + "}";
    }
}

