/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.cpp.certificate.DefaultCertificateDto;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultCertificateDtoFactory
implements IDtoFactory<DefaultCertificateDto, CppPartner> {
    private final Profiles profiles;

    public DefaultCertificateDtoFactory(Profiles profiles) {
        this.profiles = profiles;
    }

    @Override
    public DefaultCertificateDto create(CppPartner partner) {
        DefaultCertificateDto certificateDto = new DefaultCertificateDto();
        try {
            if (partner.hasPackagingId("AS1")) {
                certificateDto.setAs1(partner.getPackagingCertificateId("AS1"));
            }
            if (partner.hasPackagingId("AS2")) {
                certificateDto.setAs2(partner.getPackagingCertificateId("AS2"));
            }
            if (partner.hasPackagingId("AS3")) {
                certificateDto.setAs3(partner.getPackagingCertificateId("AS3"));
            }
            if (partner.hasPackagingId("AS4")) {
                certificateDto.setAs4(partner.getPackagingCertificateId("AS4"));
            }
            if (partner.hasPackagingId("EbXml20")) {
                certificateDto.setEbXml(partner.getPackagingCertificateId("EbXml20"));
            }
            certificateDto.setDefaultCertificate(partner.getDefaultCertRefId());
            if (partner.hasPipelineId("Messenger 2.1")) {
                certificateDto.setProcessing(partner.getPipelineCertRef("Messenger 2.1"));
            }
        }
        catch (ProfileException profileException) {
            // empty catch block
        }
        return certificateDto;
    }

    @Override
    public CppPartner parse(DefaultCertificateDto certificateDto) {
        try {
            CppPartner partner = this.profiles.getProfileForLocalId(certificateDto.getPartnerLocalId(), false);
            this.updatePackagingCertificatesInPartner(certificateDto, partner);
            return partner;
        }
        catch (ProfileException profileException) {
            return null;
        }
    }

    public void updatePackagingCertificatesInPartner(DefaultCertificateDto certificateDto, CppPartner partner) {
        try {
            if (StringUtils.isNotBlank((CharSequence)certificateDto.getAs1()) && partner.hasPackagingId("AS1")) {
                partner.setPackagingCertificate("AS1", certificateDto.getAs1());
            } else {
                partner.setPackagingCertificate("AS1", null);
            }
            if (StringUtils.isNotBlank((CharSequence)certificateDto.getAs2()) && partner.hasPackagingId("AS2")) {
                partner.setPackagingCertificate("AS2", certificateDto.getAs2());
            } else {
                partner.setPackagingCertificate("AS2", null);
            }
            if (StringUtils.isNotBlank((CharSequence)certificateDto.getAs3()) && partner.hasPackagingId("AS3")) {
                partner.setPackagingCertificate("AS3", certificateDto.getAs3());
            } else {
                partner.setPackagingCertificate("AS3", null);
            }
            if (StringUtils.isNotBlank((CharSequence)certificateDto.getAs4()) && partner.hasPackagingId("AS4")) {
                partner.setPackagingCertificate("AS4", certificateDto.getAs4());
            } else {
                partner.setPackagingCertificate("AS4", null);
            }
            if (StringUtils.isNotBlank((CharSequence)certificateDto.getEbXml()) && partner.hasPackagingId("EbXml20")) {
                partner.setPackagingCertificate("EbXml20", certificateDto.getEbXml());
            } else {
                partner.setPackagingCertificate("EbXml20", null);
            }
            partner.setDefaultCertRefId(certificateDto.getDefaultCertificate());
            if (StringUtils.isNotBlank((CharSequence)certificateDto.getProcessing()) && partner.hasPipelineId("Messenger 2.1")) {
                partner.setPipelineCertificate("Messenger 2.1", certificateDto.getProcessing());
            } else {
                partner.setPipelineCertificate("Messenger 2.1", null);
            }
        }
        catch (ProfileException profileException) {
            // empty catch block
        }
    }
}

