/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="Describes a Partner item with reduced information which an be used for example in an overview table.")
public class PartnerListItemDto {
    @Schema(description="Technical ID of the partner", required=true)
    @TrimmedField
    private String id;
    @Schema(description="The ID used for backend communication", required=true)
    @TrimmedField
    private String backendId;
    @Schema(description="Name shown in the UI", required=true)
    @TrimmedField
    private String displayName;
    @Schema(description="Determines if the configuration state of the partner is valid", required=true)
    private Boolean valid;
    @Schema(description="Determines if profile is up to date in the partner registry")
    private Boolean synced;
    @Schema(description="Profile owner in the partner registry")
    @TrimmedField
    private String owner;
    @Schema(description="true if this is a remote partner, false otherwise", required=true)
    private Boolean remote;
    @Schema(description="Timestamp of last modification", required=true)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private OffsetDateTime lastModified;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBackendId() {
        return this.backendId;
    }

    public void setBackendId(String backendId) {
        this.backendId = backendId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public Boolean getSynced() {
        return this.synced;
    }

    public void setSynced(Boolean synced) {
        this.synced = synced;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Boolean getRemote() {
        return this.remote;
    }

    public void setRemote(Boolean remote) {
        this.remote = remote;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
    }
}

