/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.validation;

import de.ponton.xmlpipe.rest.cpa.AgreementDto;
import de.ponton.xmlpipe.rest.cpa.AgreementDtoFactory;
import de.ponton.xmlpipe.rest.cpa.validation.ImmutableAgreementFieldConstraint;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.validation.CrossParameterValidator;
import de.ponton.xmlpipe.rest.validation.Immutable;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.reflect.Field;
import java.util.Objects;

@SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
public class ImmutableAgreementFieldValidator
implements ConstraintValidator<ImmutableAgreementFieldConstraint, Object[]> {
    private final Agreements agreements;
    private final CrossParameterValidator crossParameterValidator;
    private final AgreementDtoFactory agreementDtoFactory;
    private String message;

    public ImmutableAgreementFieldValidator(Agreements agreements, CrossParameterValidator crossParameterValidator, AgreementDtoFactory agreementDtoFactory) {
        this.agreements = agreements;
        this.crossParameterValidator = crossParameterValidator;
        this.agreementDtoFactory = agreementDtoFactory;
    }

    public void initialize(ImmutableAgreementFieldConstraint constraintAnnotation) {
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Object[] value, ConstraintValidatorContext context) {
        return this.crossParameterValidator.validate(value, context, this.message, this::validateField, Immutable.class);
    }

    private boolean validateField(Field field, Object ... args) {
        try {
            return Objects.equals(field.get(this.resolveResource(args[0].toString())), field.get(args[1]));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private AgreementDto resolveResource(String agreementId) {
        try {
            return this.agreementDtoFactory.create(this.agreements.getAgreement(agreementId, true));
        }
        catch (AgreementException e) {
            throw new ResourceNotFoundException(e);
        }
    }
}

