/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.validation;

import de.ponton.xmlpipe.rest.cpa.AgreementDto;
import de.ponton.xmlpipe.rest.cpa.validation.AgreementExistenceConstraint;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;

@SupportedValidationTarget(value={ValidationTarget.ANNOTATED_ELEMENT})
public class AgreementExistenceValidator
implements ConstraintValidator<AgreementExistenceConstraint, AgreementDto> {
    private final Agreements agreements;
    private boolean shouldExist;

    public AgreementExistenceValidator(Agreements agreements) {
        this.agreements = agreements;
    }

    public boolean isValid(AgreementDto agreement, ConstraintValidatorContext context) {
        if (agreement == null) {
            return true;
        }
        boolean agreementExists = this.agreements.exists(agreement.getOwnPartnerId(), agreement.getCommunicationPartnerId());
        return this.shouldExist == agreementExists;
    }

    public void initialize(AgreementExistenceConstraint constraintAnnotation) {
        this.shouldExist = constraintAnnotation.shouldExist();
    }
}

