/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing.data;

import de.ponton.xmlpipe.rest.cpa.processing.data.EncryptionFormat;

public enum EncryptionAlgorithm {
    DES_EDE3_CBC,
    AES256_CBC;


    public static EncryptionAlgorithm ofOptionValue(String optionValue) {
        switch (optionValue) {
            case "DES_EDE3_CBC": 
            case "SMIME-DES_EDE3_CBC": {
                return DES_EDE3_CBC;
            }
            case "AES256_CBC": 
            case "SMIME-AES256_CBC": {
                return AES256_CBC;
            }
        }
        return null;
    }

    public static String asOptionValue(EncryptionAlgorithm encryptionAlgorithm, EncryptionFormat encryptionFormat) {
        switch (encryptionAlgorithm.ordinal()) {
            case 0: {
                if (EncryptionFormat.PKCS7 == encryptionFormat) {
                    return "DES_EDE3_CBC";
                }
                return "SMIME-DES_EDE3_CBC";
            }
            case 1: {
                if (EncryptionFormat.PKCS7 == encryptionFormat) {
                    return "AES256_CBC";
                }
                return "SMIME-AES256_CBC";
            }
        }
        return null;
    }
}

