/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing.data;

import java.util.HashMap;
import java.util.Map;

public enum CompressionAlgorithm {
    ZLIB("Zlib"),
    DEFLATE("Deflate"),
    GZIP("GZIP"),
    ZIP("ZIP"),
    ZIP_WITH_ATTACHMENTS("ZIPwithAttachments");

    private final String name;
    private static final Map<String, CompressionAlgorithm> nameLookup;

    private CompressionAlgorithm(String name) {
        this.name = name;
    }

    public static CompressionAlgorithm of(String name) {
        return nameLookup.get(name);
    }

    public String getName() {
        return this.name;
    }

    static {
        nameLookup = new HashMap<String, CompressionAlgorithm>();
        for (CompressionAlgorithm compressionAlgorithm : CompressionAlgorithm.values()) {
            nameLookup.put(compressionAlgorithm.getName(), compressionAlgorithm);
        }
    }
}

