/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging.as4.data;

import de.pontonconsulting.xmlpipe.security.XpWSSecurity;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public enum KeyEncryptionMethod {
    RSA_OAEP("rsa-oaep"),
    RSA_OAEP_SHA1("rsa-oaep_sha1"),
    RSA_OAEP_SHA256("rsa-oaep_sha256"),
    RSA_OAEP_SHA384("rsa-oaep_sha384"),
    RSA_OAEP_SHA512("rsa-oaep_sha512"),
    RSA_OAEP_11_MGF_SHA1("rsa-oaep-11_mgf-sha1"),
    RSA_OAEP_11_MGF_SHA224("rsa-oaep-11_mgf-sha224"),
    RSA_OAEP_11_MGF_SHA256("rsa-oaep-11_mgf-sha256"),
    RSA_OAEP_11_MGF_SHA384("rsa-oaep-11_mgf-sha384"),
    RSA_OAEP_11_MGF_SHA512("rsa-oaep-11_mgf-sha512"),
    RSA_OAEP_11_SHA1_MGF_SHA1("rsa-oaep-11_sha1_mgf-sha1"),
    RSA_OAEP_11_SHA1_MGF_SHA224("rsa-oaep-11_sha1_mgf-sha224"),
    RSA_OAEP_11_SHA1_MGF_SHA256("rsa-oaep-11_sha1_mgf-sha256"),
    RSA_OAEP_11_SHA1_MGF_SHA384("rsa-oaep-11_sha1_mgf-sha384"),
    RSA_OAEP_11_SHA1_MGF_SHA512("rsa-oaep-11_sha1_mgf-sha512"),
    RSA_OAEP_11_SHA256_MGF_SHA1("rsa-oaep-11_sha256_mgf-sha1"),
    RSA_OAEP_11_SHA256_MGF_SHA224("rsa-oaep-11_sha256_mgf-sha224"),
    RSA_OAEP_11_SHA256_MGF_SHA256("rsa-oaep-11_sha256_mgf-sha256"),
    RSA_OAEP_11_SHA256_MGF_SHA384("rsa-oaep-11_sha256_mgf-sha384"),
    RSA_OAEP_11_SHA256_MGF_SHA512("rsa-oaep-11_sha256_mgf-sha512"),
    RSA_OAEP_11_SHA384_MGF_SHA1("rsa-oaep-11_sha384_mgf-sha1"),
    RSA_OAEP_11_SHA384_MGF_SHA224("rsa-oaep-11_sha384_mgf-sha224"),
    RSA_OAEP_11_SHA384_MGF_SHA256("rsa-oaep-11_sha384_mgf-sha256"),
    RSA_OAEP_11_SHA384_MGF_SHA384("rsa-oaep-11_sha384_mgf-sha384"),
    RSA_OAEP_11_SHA384_MGF_SHA512("rsa-oaep-11_sha384_mgf-sha512"),
    RSA_OAEP_11_SHA512_MGF_SHA1("rsa-oaep-11_sha512_mgf-sha1"),
    RSA_OAEP_11_SHA512_MGF_SHA224("rsa-oaep-11_sha512_mgf-sha224"),
    RSA_OAEP_11_SHA512_MGF_SHA256("rsa-oaep-11_sha512_mgf-sha256"),
    RSA_OAEP_11_SHA512_MGF_SHA384("rsa-oaep-11_sha512_mgf-sha384"),
    RSA_OAEP_11_SHA512_MGF_SHA512("rsa-oaep-11_sha512_mgf-sha512"),
    ECDH_ES_CONCATKDF_EMPTY_SHA256("ECDH-ES-ConcatKDF-empty-sha256"),
    ECDH_ES_CONCATKDF_EMPTY_SHA512("ECDH-ES-ConcatKDF-empty-sha512"),
    ECDH_ES_CONCATKDF_GENERATED_SHA256("ECDH-ES-ConcatKDF-generated-sha256"),
    ECDH_ES_CONCATKDF_GENERATED_SHA512("ECDH-ES-ConcatKDF-generated-sha512");

    private static final Map<String, KeyEncryptionMethod> nameLookup;
    private static final Logger LOG;
    private final String name;

    private KeyEncryptionMethod(String name) {
        this.name = name;
    }

    public static KeyEncryptionMethod of(String name) {
        return nameLookup.get(name);
    }

    public String getName() {
        return this.name;
    }

    static {
        nameLookup = new HashMap<String, KeyEncryptionMethod>();
        LOG = LogManager.getLogger((String)KeyEncryptionMethod.class.getName());
        for (KeyEncryptionMethod keyEncryptionMethod : KeyEncryptionMethod.values()) {
            nameLookup.put(keyEncryptionMethod.getName(), keyEncryptionMethod);
        }
        if (XpWSSecurity.keyEncAlgoToKeyEncAlgoObject.keySet().size() != nameLookup.size()) {
            LOG.error("Not all supported Key Encryption Methods are defined as enums.\nkeyEncAlgoToKeyEncAlgoObject: {}\nnameLookup: {}", (Object)String.join((CharSequence)",", XpWSSecurity.keyEncAlgoToKeyEncAlgoObject.keySet()), (Object)String.join((CharSequence)",", nameLookup.keySet()));
        }
        Assert.isTrue((XpWSSecurity.keyEncAlgoToKeyEncAlgoObject.keySet().size() == nameLookup.size() ? 1 : 0) != 0, (String)"Not all supported Key Encryption Methods are defined as enums.");
    }
}

