/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging.as123;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.MICAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.validation.RequestAcknowledgementsConstraint;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.NullOrNotBlank;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@RequestAcknowledgementsConstraint
@Schema(description="Packaging options for requesting acknowledgements", name="Agreement.AS123.RequestAcknowledgements")
public class RequestAcknowledgementsDto {
    private boolean requestSignedAcknowledgements;
    @JsonProperty(value="MICAlgorithm")
    @Schema(description="The message integrity code (MIC) algorithm. This is used to verify that the received content is correct.")
    private MICAlgorithm micAlgorithm;
    @NullOrNotBlank
    @Schema(description="when this URL is set, then the receiver of a message is expected to send the acknowledgement (MDN) to this URL")
    @TrimmedField
    private String asynchronousReplyURL;

    public boolean isRequestSignedAcknowledgements() {
        return this.requestSignedAcknowledgements;
    }

    public RequestAcknowledgementsDto setRequestSignedAcknowledgements(boolean requestSignedAcknowledgements) {
        this.requestSignedAcknowledgements = requestSignedAcknowledgements;
        return this;
    }

    public MICAlgorithm getMicAlgorithm() {
        return this.micAlgorithm;
    }

    public RequestAcknowledgementsDto setMicAlgorithm(MICAlgorithm micAlgorithm) {
        this.micAlgorithm = micAlgorithm;
        return this;
    }

    public String getAsynchronousReplyURL() {
        return this.asynchronousReplyURL;
    }

    public RequestAcknowledgementsDto setAsynchronousReplyURL(String asynchronousReplyURL) {
        this.asynchronousReplyURL = asynchronousReplyURL;
        return this;
    }
}

