/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging;

import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PackageIdNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class PackagingUtility {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));

    public Optional<String> getPackagingOptionValue(Communication communication, String path) {
        try {
            return Optional.ofNullable(communication.getPackagingOptionValue(path));
        }
        catch (OptionNotFoundException e) {
            return Optional.empty();
        }
    }

    public void removePackagingOptionValue(Communication communication, String path) {
        this.setPackagingOptionValue(communication, path, (String)null, null);
    }

    public void setPackagingOptionValue(Communication communication, String path, boolean value, String type) {
        this.setPackagingOptionValue(communication, path, Boolean.valueOf(value).toString(), type);
    }

    public void setPackagingOptionValue(Communication communication, String path, String value, String type) {
        try {
            if (value != null) {
                communication.setPackagingOptionValue(path, value, type);
            } else {
                communication.deletePackagingOption(path);
            }
        }
        catch (OptionNotFoundException | PackageIdNotFoundException idNotFoundException) {
            // empty catch block
        }
    }

    public List<Option> getChildOptions(Communication communication, String path) {
        try {
            return Arrays.asList(communication.getPackagingOption(path).getSubOptions());
        }
        catch (OptionNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public void setChildOption(Communication communication, String path, Option ... options) {
        try {
            communication.getPackagingOption(path).setSubOptions(options);
        }
        catch (OptionNotFoundException e) {
            this.log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void setPackagingOptionValue(Communication communication, String path, Supplier<String> value, String type) {
        this.setPackagingOptionValue(communication, path, value.get(), type);
    }
}

