/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.cpa.packaging.IPackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.AgreementReferenceDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.EncryptMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ExpectEncryptedMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ExpectReceiptsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ExpectSignedDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.SendReceiptsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ServiceDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.SigningDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.MessageProperty;
import de.ponton.xmlpipe.rest.cpa.packaging.validation.EnableCertificateUpdateConstraint;
import de.ponton.xmlpipe.rest.cpa.validation.AgreementRefConstraint;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.NullOrNotBlank;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.constraints.UniqueElements;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="AS4 Packaging options", name="Agreement.AS4")
@EnableCertificateUpdateConstraint
public class AS4PackagingDto
implements IPackagingDto {
    @NotBlank
    private final String type = "AS4";
    @NullOrNotBlank
    @Schema(description="This value can be used to define a business related role for the sender. The PONTON X/P Messenger does not process this value.")
    @TrimmedField
    private String roleFrom;
    @NullOrNotBlank
    @Schema(description="This value can be used to define a business related role for the receiver. The PONTON X/P Messenger does not process this value.")
    @TrimmedField
    private String roleTo;
    @Valid
    @NotNull
    private ServiceDto service;
    @NotBlank
    @TrimmedField
    private String action;
    @NullOrNotBlank
    @Schema(description="This value can be used to override MIME Content ID (cid). The PONTON X/P Messenger does not process this value.")
    @TrimmedField
    private String cid;
    @Valid
    @Schema(description="This is an identifier for the agreed communication settings between sender and receiver. The PONTON X/P Messenger does not process this value.")
    @AgreementRefConstraint
    private AgreementReferenceDto agreementReference;
    @Schema(description="This flag will add general data to the AS4 envelope like Messenger Version and Test-Flag. It will have no impact on the processing at the receiver.")
    private boolean includeMessageProperties;
    @Schema(description="This flag will add payload dependent data to the AS4 envelope like the message type, schemaset and message type version. If the receiver uses PONTON X/P Messenger, then this data will be used to identify the payload.")
    private boolean includeContentProperties;
    @Schema(description="This flag will enable the sending of standard AS4 AgreementUpdate messages, whenever a new certificate is installed. It also enabled processing of incoming AgreementUpdate messages, and installaing new certificates for communication partners. It is required that an AgreementReference is defined for this to work.")
    private boolean enableCertificateUpdateMessages;
    @Valid
    @Schema(description="When this structure exists, then all send messages will be signed.")
    private SigningDto signMessages;
    @Valid
    @Schema(description="When this structure exists, then all received messages are expected to be signed.")
    private ExpectSignedDto expectSignedMessages;
    @Valid
    @Schema(description="When this structure exists, then all send messages will be encrypted.")
    private EncryptMessagesDto encryptMessages;
    @Valid
    @Schema(description="When this structure exists, then all received messages are expected to be encrypted.")
    private ExpectEncryptedMessagesDto expectEncryptedMessages;
    @Schema(description="When this structure exists, then all send messages will be compressed.")
    private boolean compressMessages;
    @Schema(description="When this structure exists, then all received messages are expected to be compressed.")
    private boolean expectCompressedMessages;
    @Valid
    @Schema(description="When this structure exists, it is expected that the receiver sends a receipt (acknowledgement) for all transmitted messages.")
    private ExpectReceiptsDto expectReceipts;
    @Valid
    @Schema(description="When this structure exists, a receipt (acknowledgement) will be sent for all received messages.")
    private SendReceiptsDto sendReceipts;
    @Schema(description="If a messages is received that has the same message id as a previously successfully received message, it will be ignored if this flag is enabled.")
    private boolean ignoreDuplicateMessages;
    @Schema(description="If set the conversation ID in the AS4 envelope will be empty.")
    private boolean emptyConversationId;
    @Schema(description="List of Content Properties to be added to AS4 if enabled.")
    @UniqueElements
    private List<MessageProperty> contentProperties = new ArrayList<MessageProperty>();
    @Schema(description="List of Message Properties to be added to AS4 if enabled.")
    @UniqueElements
    private List<MessageProperty> messageProperties = new ArrayList<MessageProperty>();

    @Override
    public String getType() {
        return "AS4";
    }

    public String getRoleFrom() {
        return this.roleFrom;
    }

    public AS4PackagingDto setRoleFrom(String roleFrom) {
        this.roleFrom = roleFrom;
        return this;
    }

    public String getRoleTo() {
        return this.roleTo;
    }

    public AS4PackagingDto setRoleTo(String roleTo) {
        this.roleTo = roleTo;
        return this;
    }

    public ServiceDto getService() {
        return this.service;
    }

    public AS4PackagingDto setService(ServiceDto service) {
        this.service = service;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public AS4PackagingDto setAction(String action) {
        this.action = action;
        return this;
    }

    public String getCid() {
        return this.cid;
    }

    public AS4PackagingDto setCid(String cid) {
        this.cid = cid;
        return this;
    }

    public AgreementReferenceDto getAgreementReference() {
        return this.agreementReference;
    }

    public AS4PackagingDto setAgreementReference(AgreementReferenceDto agreementReference) {
        this.agreementReference = agreementReference;
        return this;
    }

    public boolean isIncludeMessageProperties() {
        return this.includeMessageProperties;
    }

    public AS4PackagingDto setIncludeMessageProperties(boolean includeMessageProperties) {
        this.includeMessageProperties = includeMessageProperties;
        return this;
    }

    public boolean isIncludeContentProperties() {
        return this.includeContentProperties;
    }

    public AS4PackagingDto setIncludeContentProperties(boolean includeContentProperties) {
        this.includeContentProperties = includeContentProperties;
        return this;
    }

    public boolean isEnableCertificateUpdateMessages() {
        return this.enableCertificateUpdateMessages;
    }

    public AS4PackagingDto setEnableCertificateUpdateMessages(boolean enableCertificateUpdateMessages) {
        this.enableCertificateUpdateMessages = enableCertificateUpdateMessages;
        return this;
    }

    public SigningDto getSignMessages() {
        return this.signMessages;
    }

    public AS4PackagingDto setSignMessages(SigningDto signMessages) {
        this.signMessages = signMessages;
        return this;
    }

    public ExpectSignedDto getExpectSignedMessages() {
        return this.expectSignedMessages;
    }

    public AS4PackagingDto setExpectSignedMessages(ExpectSignedDto expectSignedMessages) {
        this.expectSignedMessages = expectSignedMessages;
        return this;
    }

    public EncryptMessagesDto getEncryptMessages() {
        return this.encryptMessages;
    }

    public AS4PackagingDto setEncryptMessages(EncryptMessagesDto encryptMessages) {
        this.encryptMessages = encryptMessages;
        return this;
    }

    public ExpectEncryptedMessagesDto getExpectEncryptedMessages() {
        return this.expectEncryptedMessages;
    }

    public AS4PackagingDto setExpectEncryptedMessages(ExpectEncryptedMessagesDto expectEncryptedMessages) {
        this.expectEncryptedMessages = expectEncryptedMessages;
        return this;
    }

    public boolean isCompressMessages() {
        return this.compressMessages;
    }

    public AS4PackagingDto setCompressMessages(boolean compressMessages) {
        this.compressMessages = compressMessages;
        return this;
    }

    public boolean isExpectCompressedMessages() {
        return this.expectCompressedMessages;
    }

    public AS4PackagingDto setExpectCompressedMessages(boolean expectCompressedMessages) {
        this.expectCompressedMessages = expectCompressedMessages;
        return this;
    }

    public ExpectReceiptsDto getExpectReceipts() {
        return this.expectReceipts;
    }

    public AS4PackagingDto setExpectReceipts(ExpectReceiptsDto expectReceipts) {
        this.expectReceipts = expectReceipts;
        return this;
    }

    public SendReceiptsDto getSendReceipts() {
        return this.sendReceipts;
    }

    public AS4PackagingDto setSendReceipts(SendReceiptsDto sendReceipts) {
        this.sendReceipts = sendReceipts;
        return this;
    }

    public boolean isIgnoreDuplicateMessages() {
        return this.ignoreDuplicateMessages;
    }

    public AS4PackagingDto setIgnoreDuplicateMessages(boolean ignoreDuplicateMessages) {
        this.ignoreDuplicateMessages = ignoreDuplicateMessages;
        return this;
    }

    public boolean isEmptyConversationId() {
        return this.emptyConversationId;
    }

    public void setEmptyConversationId(boolean emptyConversationId) {
        this.emptyConversationId = emptyConversationId;
    }

    public List<MessageProperty> getContentProperties() {
        return this.contentProperties;
    }

    public AS4PackagingDto setContentProperties(List<MessageProperty> contentProperties) {
        this.contentProperties = contentProperties;
        return this;
    }

    public List<MessageProperty> getMessageProperties() {
        return this.messageProperties;
    }

    public AS4PackagingDto setMessageProperties(List<MessageProperty> messageProperties) {
        this.messageProperties = messageProperties;
        return this;
    }
}

