/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa;

import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import de.ponton.xmlpipe.rest.cpa.AgreementDto;
import de.ponton.xmlpipe.rest.cpa.AgreementDtoFactory;
import de.ponton.xmlpipe.rest.cpa.AgreementListItemDto;
import de.ponton.xmlpipe.rest.cpa.AgreementTemplateIdsDto;
import de.ponton.xmlpipe.rest.cpa.AgreementTemplateListItemDto;
import de.ponton.xmlpipe.rest.cpa.validation.AgreementExistenceConstraint;
import de.ponton.xmlpipe.rest.cpa.validation.AgreementTemplateExistenceConstraint;
import de.ponton.xmlpipe.rest.cpa.validation.ImmutableAgreementFieldConstraint;
import de.ponton.xmlpipe.rest.cpp.validation.PartnerExistenceConstraint;
import de.ponton.xmlpipe.rest.cpp.validation.PartnerType;
import de.ponton.xmlpipe.rest.cpp.validation.PartnerTypeConstraint;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.exception.InvalidAuthenticationException;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.AgreementTemplates;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.AgreementListItem;
import de.pontonconsulting.xmlpipe.security.acegi.ClientRoleService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/agreements"})
@Validated
public class AgreementController {
    public static final String DOCUMENTATION_TAG_AGREEMENT = "Agreement";
    public static final String DOCUMENTATION_TAG_AGREEMENT_LIST_ITEMS = "Agreement / List Items";
    public static final String DOCUMENTATION_TAG_AGREEMENT_TEMPLATE_IDS = "Agreement / Template IDs";
    public static final String DOCUMENTATION_TAG_AGREEMENT_TEMPLATES_LIST_ITEMS = "Agreement / Template IDs / List Items";
    public static final String DOCUMENTATION_TAG_AGREEMENT_PROPOSAL = "Agreement / Proposal";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final Agreements agreements;
    private final AgreementDtoFactory agreementDtoFactory;
    private final ExceptionDtoFactory exceptionDtoFactory;
    private final DistributionConfigFinder distributionConfigFinder;
    private final ClientRoleService clientRoleService;
    private final AgreementTemplates agreementTemplates;
    private final ConfigResourceService configResourceService;

    public AgreementController(Agreements agreements, AgreementDtoFactory agreementDtoFactory, ExceptionDtoFactory exceptionDtoFactory, DistributionConfigFinder distributionConfigFinder, ClientRoleService clientRoleService, AgreementTemplates agreementTemplates, ConfigResourceService configResourceService) {
        this.agreements = agreements;
        this.agreementDtoFactory = agreementDtoFactory;
        this.exceptionDtoFactory = exceptionDtoFactory;
        this.distributionConfigFinder = distributionConfigFinder;
        this.clientRoleService = clientRoleService;
        this.agreementTemplates = agreementTemplates;
        this.configResourceService = configResourceService;
    }

    @Operation(summary="Create an Agreement", description="permission:AGREEMENTS_POST<br><br>The passed Agreement is created on the messenger and returned to the caller if creation was successful.", tags={"Agreement"})
    @PostMapping
    @Secured(value={"AGREEMENTS_POST"})
    @Validated(value={ValidationGroup.Create.class})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<AgreementDto> createAgreement(@RequestBody @Valid @AgreementExistenceConstraint(shouldExist=false) @Parameter(description="The Agreement data transfer object") AgreementDto agreementDto) throws Exception {
        try {
            this.checkAuthenticationValidity(agreementDto);
        }
        catch (InvalidAuthenticationException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)agreementDto);
        }
        Agreement agreement = this.agreements.createAgreement(agreementDto.getOwnPartnerId(), agreementDto.getCommunicationPartnerId(), agreementDto.getTemplateId());
        this.agreementDtoFactory.updateAgreementFromDTO(agreement, agreementDto);
        agreement.save();
        AgreementDto returnValue = this.agreementDtoFactory.create(agreement);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)returnValue);
    }

    @Operation(summary="Create an Agreement Proposal", description="permission:AGREEMENTS_PROPOSAL_GET<br><br>A new agreement proposal for the given partners is created based on the given template. The agreement is not saved.", tags={"Agreement / Proposal"})
    @GetMapping(value={"/proposal/{partner1Id}/{partner2Id}/{templateId}"})
    @Secured(value={"AGREEMENTS_PROPOSAL_GET"})
    public ResponseEntity<AgreementDto> createAgreementProposal(@PathVariable @Parameter(description="The id of the first partner for the agreement. This must be local partner") @PartnerExistenceConstraint @PartnerTypeConstraint(value=PartnerType.LOCAL) String partner1Id, @PathVariable @Parameter(description="The id of the second partner for the agreement") @PartnerExistenceConstraint @PartnerTypeConstraint(value=PartnerType.LOCAL_OR_REMOTE) String partner2Id, @PathVariable @Parameter(description="The template id for the agreement creation") @AgreementTemplateExistenceConstraint String templateId) throws AgreementException {
        Agreement agreementProposal = this.agreements.createAgreementProposal(partner1Id, partner2Id, templateId);
        AgreementDto agreementDto = this.agreementDtoFactory.create(agreementProposal);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)agreementDto);
    }

    @Operation(summary="Get an Agreement", description="permission:AGREEMENTS_GET<br><br>Returns the Agreement with the passed id.", tags={"Agreement"})
    @GetMapping(value={"/{agreementId}"})
    @Secured(value={"AGREEMENTS_GET"})
    public ResponseEntity<AgreementDto> getAgreement(@PathVariable @Parameter(description="The id of the Agreement") String agreementId) throws AgreementException {
        Agreement agreement = this.agreements.getAgreement(agreementId, true);
        AgreementDto agreementDto = this.agreementDtoFactory.create(agreement);
        return ResponseEntity.ok((Object)agreementDto);
    }

    @Operation(summary="Get a list of all Agreements as list items containing the partner informations", description="permission:AGREEMENTS_LIST_ITEMS_GET<br><br>Returns a list of Agreements list items. These items contain information about the affected partners.", tags={"Agreement / List Items"})
    @GetMapping(value={"/listitems"})
    @Secured(value={"AGREEMENTS_LIST_ITEMS_GET"})
    public ResponseEntity<List<AgreementListItemDto>> getAllAgreementsAsListItems(Principal principal) {
        List<AgreementListItemDto> allAgreements = this.agreements.getAgreementList().stream().filter(agreement -> this.clientRoleService.verifyAgreementAccess(agreement.getId(), principal.getName())).map(AgreementListItem::convertToDto).toList();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body(allAgreements);
    }

    @Operation(summary="Update an Agreement", description="permission:AGREEMENTS_PUT<br><br>Updates the Agreement with the passed id.", tags={"Agreement"})
    @PutMapping(value={"/{agreementId}"})
    @Secured(value={"AGREEMENTS_PUT"})
    @Validated(value={ValidationGroup.Update.class})
    @ImmutableAgreementFieldConstraint
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> updateAgreement(@PathVariable @Parameter(description="The id of the Agreement to update") String agreementId, @RequestBody @Valid @Parameter(description="The Agreement data transfer object") AgreementDto agreementDto) throws AgreementException {
        try {
            this.checkAuthenticationValidity(agreementDto);
        }
        catch (InvalidAuthenticationException e) {
            throw new InvalidAuthenticationException();
        }
        agreementDto.setId(agreementId);
        Agreement agreement = this.agreementDtoFactory.parse(agreementDto);
        agreement.save();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @Operation(summary="Deletes an Agreement", description="permission:AGREEMENTS_DELETE<br><br>Deletes the Agreement with the passed id.", tags={"Agreement"})
    @DeleteMapping(value={"/{agreementId}"})
    @Secured(value={"AGREEMENTS_DELETE"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteAgreement(@PathVariable @Parameter(description="The id of the Agreement") String agreementId) throws AgreementException {
        this.agreements.removeAgreement(agreementId, true);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @Operation(summary="Get a list of all Agreement Template IDs", description="permission:AGREEMENTS_TEMPLATE_IDS_GET<br><br>Returns a list of Agreement Template IDs", tags={"Agreement / Template IDs"})
    @GetMapping(value={"/templateids"})
    @Secured(value={"AGREEMENTS_TEMPLATE_IDS_GET"})
    public ResponseEntity<AgreementTemplateIdsDto> getAllAgreementTemplateIds() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)new AgreementTemplateIdsDto().setTemplateIds(this.distributionConfigFinder.getAgreementTemplateIds()).setDefaultTemplateId(this.distributionConfigFinder.getDefaultAgreementTemplateId()));
    }

    @Operation(summary="Get a list of all Agreement Templates as list items", description="permission:AGREEMENTS_TEMPLATE_IDS_GET<br><br>Returns a list of Agreement Templates list items.", tags={"Agreement / Template IDs / List Items"})
    @GetMapping(value={"/templateids/listitems"})
    @Secured(value={"AGREEMENT_TEMPLATE_GET"})
    public ResponseEntity<List<AgreementTemplateListItemDto>> getAllAgreementTemplatesAsListItems() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body(this.distributionConfigFinder.getAgreementTemplateList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Create a new Agreement Template", description="permission:AGREEMENTS_TEMPLATE_IDS_POST<br><br>Creates a new Agreement Template and stores it.", tags={"Agreement / Template IDs"})
    @PostMapping(value={"/templateids"})
    @Secured(value={"AGREEMENT_TEMPLATE_POST"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> createAgreementTemplate(@RequestPart(value="publicFile") MultipartFile publicFile, @RequestPart(value="privateFile") MultipartFile privateFile, Principal principal) throws IOException {
        Path agreementTemplateFolder = Files.createTempDirectory("agreementTemplate", new FileAttribute[0]);
        try {
            ResponseEntity responseEntity;
            Path tempPublicFilePath = agreementTemplateFolder.resolve(Objects.requireNonNull(publicFile.getOriginalFilename()));
            Path tempPrivateFilePath = agreementTemplateFolder.resolve(Objects.requireNonNull(privateFile.getOriginalFilename()));
            try {
                publicFile.transferTo(tempPublicFilePath);
                privateFile.transferTo(tempPrivateFilePath);
                URL publicFileUrl = tempPublicFilePath.toUri().toURL();
                URL privateFileUrl = tempPrivateFilePath.toUri().toURL();
                this.agreementTemplates.createAgreementTemplate(publicFileUrl, privateFileUrl, principal.getName());
                this.configResourceService.clearCache();
                this.configResourceService.init();
                this.distributionConfigFinder.refreshAgreementTemplates();
                responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
            }
            catch (Throwable throwable) {
                Files.deleteIfExists(tempPublicFilePath);
                Files.deleteIfExists(tempPrivateFilePath);
                throw throwable;
            }
            Files.deleteIfExists(tempPublicFilePath);
            Files.deleteIfExists(tempPrivateFilePath);
            return responseEntity;
        }
        finally {
            Files.deleteIfExists(agreementTemplateFolder);
        }
    }

    @Operation(summary="Get an Agreement Template", description="permission:AGREEMENTS_TEMPLATE_IDS_GET<br><br>Returns the content of the Agreement Template with the passed id.", tags={"Agreement / Template IDs"})
    @GetMapping(value={"/templateids/{templateId}"})
    @Secured(value={"AGREEMENT_TEMPLATE_GET"})
    public ResponseEntity<String> getAgreementTemplate(@PathVariable @Parameter(description="The id of the Agreement Template to retrieve") String templateId, @RequestParam @Parameter(description="Indicates if the template is public") Boolean isPublic) throws FileNotFoundException {
        String content = this.agreementTemplates.getAgreementTemplateContent(templateId, isPublic);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)content);
    }

    @Operation(summary="Update an Agreement Template", description="permission:AGREEMENTS_TEMPLATE_IDS_PUT<br><br>Updates the Agreement Template with the passed id.", tags={"Agreement / Template IDs"})
    @PutMapping(value={"/templateids/{templateId}"})
    @Secured(value={"AGREEMENT_TEMPLATE_PUT"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> updateAgreementTemplate(@PathVariable @Parameter(description="The id of the Agreement Template to update") String templateId, @RequestParam @Parameter(description="Indicates if the template is public") Boolean isPublic, @RequestBody @Parameter(description="The content of the Agreement Template") String content, Principal principal) throws IOException {
        this.agreementTemplates.saveAgreementTemplate(templateId, isPublic, content, principal.getName());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @Operation(summary="Delete an Agreement Template", description="permission:AGREEMENTS_TEMPLATE_IDS_DELETE<br><br>Deletes the Agreement Template with the passed id.", tags={"Agreement / Template IDs"})
    @DeleteMapping(value={"/templateids/{templateId}"})
    @Secured(value={"AGREEMENT_TEMPLATE_DELETE"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteAgreementTemplate(@PathVariable @Parameter(description="The id of the Agreement Template to delete") String templateId, @RequestParam @Parameter(description="Indicates if the template is public") Boolean isPublic, Principal principal) throws IOException {
        this.agreementTemplates.deleteAgreementTemplate(templateId, isPublic, principal.getName());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @ExceptionHandler(value={CommunicationNotFoundException.class, AgreementNotFoundException.class, ProfileNotFoundException.class, ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleNotFound(Exception e) {
        this.log.error("Resource not found, {}", (Object)e.toString());
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(cause), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={AgreementException.class, ProfileException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleInternalServerError(Exception e) {
        this.log.error("Error while creating agreement, {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidTypeIdException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleInvalidTypeIdException(InvalidTypeIdException e) {
        return new ResponseEntity((Object)this.exceptionDtoFactory.create((Throwable)e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ExceptionDto> handleIllegalArgumentException(IllegalArgumentException e) {
        this.log.error("Error while get agreement, {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidAuthenticationException.class})
    public ResponseEntity<ExceptionDto> handleInvalidAuthenticationException(InvalidAuthenticationException e) {
        this.log.error("Error while get agreement, {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private void checkAuthenticationValidity(AgreementDto agreement) throws InvalidAuthenticationException {
        if (agreement.getCommunication() == null) {
            return;
        }
        if (agreement.getCommunication().getUsername() == null && agreement.getCommunication().getPassword() != null) {
            throw new InvalidAuthenticationException();
        }
        if (agreement.getCommunication().getPassword() == null && agreement.getCommunication().getUsername() != null) {
            throw new InvalidAuthenticationException();
        }
        if ("".equals(agreement.getCommunication().getPassword()) || "".equals(agreement.getCommunication().getUsername())) {
            throw new InvalidAuthenticationException();
        }
    }
}

