/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.configuration;

import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Component
public class ResponseHeaderFilter
implements Filter {
    private boolean useHTST = false;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader("Cache-Control", "no-store");
        if (this.useHTST) {
            httpServletResponse.setHeader("Strict-Transport-Security", "max-age=63072000");
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        IMessengerProperties messengerProperties = (IMessengerProperties)ctx.getBean(IMessengerProperties.class);
        this.useHTST = Boolean.parseBoolean(messengerProperties.getProperty("ponton.messenger.rest.hsts", "false"));
    }

    public void destroy() {
    }
}

