/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.certificate;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.certificate.ExtendedKeyUsage;
import de.ponton.xmlpipe.rest.certificate.KeyUsage;
import de.ponton.xmlpipe.rest.certificate.SubjectAlternativeNameDto;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.List;

@Schema(description="Holds the information of a certificate.")
public class CertificateDto {
    @Schema(description="The id of this Certificate")
    @TrimmedField
    protected String id;
    @Schema(description="The subject of this Certificate")
    @TrimmedField
    protected String subject;
    @Schema(description="The issuer of this Certificate")
    @TrimmedField
    protected String issuer;
    @Schema(description="The serial number of this Certificate")
    @TrimmedField
    protected String serialNumber;
    @Schema(description="The key algorithm of this Certificate")
    @TrimmedField
    protected String keyAlgorithm;
    @Schema(description="The Subject Alternative Names (SAN) of this Certificate")
    protected List<SubjectAlternativeNameDto> subjectAlternativeNames;
    @Schema(description="The Key Usages of this Certificate")
    protected List<KeyUsage> keyUsages;
    @Schema(description="The Extended Key Usages of this Certificate")
    protected List<ExtendedKeyUsage> extendedKeyUsages;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    @Schema(description="The valid from date of this Certificate")
    protected OffsetDateTime validFrom;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    @Schema(description="The valid to date of this Certificate")
    protected OffsetDateTime validTo;
    @Schema(description="The certificate as Base64 encoded string")
    @TrimmedField
    protected String certificate;

    public String getId() {
        return this.id;
    }

    public CertificateDto setId(String id) {
        this.id = id;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public CertificateDto setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public CertificateDto setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public CertificateDto setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public CertificateDto setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return this;
    }

    public List<SubjectAlternativeNameDto> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public CertificateDto setSubjectAlternativeNames(List<SubjectAlternativeNameDto> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    public List<KeyUsage> getKeyUsages() {
        return this.keyUsages;
    }

    public CertificateDto setKeyUsages(List<KeyUsage> keyUsages) {
        this.keyUsages = keyUsages;
        return this;
    }

    public List<ExtendedKeyUsage> getExtendedKeyUsages() {
        return this.extendedKeyUsages;
    }

    public CertificateDto setExtendedKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
        this.extendedKeyUsages = extendedKeyUsages;
        return this;
    }

    public OffsetDateTime getValidFrom() {
        return this.validFrom;
    }

    public CertificateDto setValidFrom(OffsetDateTime validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    public OffsetDateTime getValidTo() {
        return this.validTo;
    }

    public CertificateDto setValidTo(OffsetDateTime validTo) {
        this.validTo = validTo;
        return this;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public CertificateDto setCertificate(String certificate) {
        this.certificate = certificate;
        return this;
    }
}

