/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.adapter;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Describes details of an adapter")
public class AdapterDto {
    @NotNull
    @Schema(description="The id of the adapter")
    @TrimmedField
    private String id;
    @NotNull
    @Schema(description="The address of adapter as url")
    @TrimmedField
    private String address;
    @Schema(description="The adapter supports acknowledgements")
    private boolean supportsAcknowledgements;
    @Schema(description="The adapter supports attachments")
    private boolean supportsAttachments;
    @Schema(description="The adapter accepts partner change events")
    private boolean acceptsPartnerChangeEvents;
    @Schema(description="The adapter accepts partner certificate change events")
    private boolean acceptsPartnerCertificateChangeEvents;
    @Schema(description="The adapter accepts agreements change events")
    private boolean acceptsAgreementChangeEvents;
    @Schema(description="The adapter supports status responses")
    private boolean supportsStatusResponses;
    @Schema(description="The adapter supports error notifications")
    private boolean supportsErrorNotifications;
    @Schema(description="The processing timeout for this adapter")
    private int processingTimeout;
    @Schema(description="The adapter's maximum number of parallel receiving threads")
    private int maximumThreads;

    public String getId() {
        return this.id;
    }

    public AdapterDto setId(String id) {
        this.id = id;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public AdapterDto setAddress(String address) {
        this.address = address;
        return this;
    }

    public boolean isSupportsAcknowledgements() {
        return this.supportsAcknowledgements;
    }

    public AdapterDto setSupportsAcknowledgements(boolean supportsAcknowledgements) {
        this.supportsAcknowledgements = supportsAcknowledgements;
        return this;
    }

    public boolean isSupportsAttachments() {
        return this.supportsAttachments;
    }

    public AdapterDto setSupportsAttachments(boolean supportsAttachments) {
        this.supportsAttachments = supportsAttachments;
        return this;
    }

    public boolean isAcceptsPartnerChangeEvents() {
        return this.acceptsPartnerChangeEvents;
    }

    public AdapterDto setAcceptsPartnerChangeEvents(boolean acceptsPartnerChangeEvents) {
        this.acceptsPartnerChangeEvents = acceptsPartnerChangeEvents;
        return this;
    }

    public boolean isAcceptsPartnerCertificateChangeEvents() {
        return this.acceptsPartnerCertificateChangeEvents;
    }

    public AdapterDto setAcceptsPartnerCertificateChangeEvents(boolean acceptsPartnerCertificateChangeEvents) {
        this.acceptsPartnerCertificateChangeEvents = acceptsPartnerCertificateChangeEvents;
        return this;
    }

    public boolean isAcceptsAgreementChangeEvents() {
        return this.acceptsAgreementChangeEvents;
    }

    public AdapterDto setAcceptsAgreementChangeEvents(boolean acceptsAgreementChangeEvents) {
        this.acceptsAgreementChangeEvents = acceptsAgreementChangeEvents;
        return this;
    }

    public boolean isSupportsStatusResponses() {
        return this.supportsStatusResponses;
    }

    public AdapterDto setSupportsStatusResponses(boolean supportsStatusResponses) {
        this.supportsStatusResponses = supportsStatusResponses;
        return this;
    }

    public boolean isSupportsErrorNotifications() {
        return this.supportsErrorNotifications;
    }

    public AdapterDto setSupportsErrorNotifications(boolean supportsErrorNotifications) {
        this.supportsErrorNotifications = supportsErrorNotifications;
        return this;
    }

    public int getProcessingTimeout() {
        return this.processingTimeout;
    }

    public AdapterDto setProcessingTimeout(int processingTimeout) {
        this.processingTimeout = processingTimeout;
        return this;
    }

    public int getMaximumThreads() {
        return this.maximumThreads;
    }

    public AdapterDto setMaximumThreads(int maximumThreads) {
        this.maximumThreads = maximumThreads;
        return this;
    }
}

