/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import com.codahale.metrics.Timer;
import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.metrics.XPMetrics;
import de.ponton.xmlpipe.queue.IQueueMessageSendingTask;
import de.ponton.xmlpipe.queue.InboundQueue;
import de.ponton.xmlpipe.queue.InboundQueueMessage;
import de.pontonconsulting.common.file.FileUtils;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessException;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessFactory;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterCustomException;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterRejectedMessageException;
import de.pontonconsulting.xmlpipe.messenger.adapter.IAdapterAccess;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueueMessageSendingInboundTask
implements IQueueMessageSendingTask {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final InboundQueue inboundMessageQueue;
    private final MessageDAO messageDAO;
    private final IFolders folders;
    private final ArchiveProcessor archiveProcessor;
    private final MessengerLog messengerLog;
    private final AdapterAccessFactory adapterAccessFactory;
    private final MetricsService metricsService;
    private final MessengerConfig messengerConfig;
    private final ReferenceDateTask referenceDateTask;
    private final InboundQueueMessage inboundMessage;
    private final String destinationAdapter;
    private final Runnable callback;
    private final AtomicInteger numberOfConnectTries;
    private final AdapterRegistry adapterRegistry;
    private final MessageWorkDataDAO messageWorkDataDAO;
    private final int adapterConnectRetries;
    private final long adapterConnectInterval;

    public QueueMessageSendingInboundTask(InboundQueue inboundMessageQueue, MessageDAO messageDAO, IFolders folders, ArchiveProcessor archiveProcessor, MessengerLog messengerLog, AdapterAccessFactory adapterAccessFactory, MetricsService metricsService, MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask, InboundQueueMessage queueMessage, AdapterRegistry adapterRegistry, String destinationAdapter, Runnable callback, MessageWorkDataDAO messageWorkDataDAO, int adapterConnectRetries, long adapterConnectInterval) {
        this.inboundMessageQueue = inboundMessageQueue;
        this.messageDAO = messageDAO;
        this.folders = folders;
        this.archiveProcessor = archiveProcessor;
        this.messengerLog = messengerLog;
        this.adapterAccessFactory = adapterAccessFactory;
        this.metricsService = metricsService;
        this.messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
        this.inboundMessage = queueMessage;
        this.destinationAdapter = destinationAdapter;
        this.adapterRegistry = adapterRegistry;
        this.callback = callback;
        this.messageWorkDataDAO = messageWorkDataDAO;
        this.adapterConnectRetries = adapterConnectRetries;
        this.adapterConnectInterval = adapterConnectInterval;
        this.numberOfConnectTries = new AtomicInteger(0);
    }

    @Override
    public Void call() throws Exception {
        Profiles.initThreadCache();
        Agreements.initThreadCache();
        try {
            MessageDAO.putDbIdToThreadContext(this.inboundMessage.getUniqueId());
            long timeout = this.inboundMessage.getQueuedTimestamp() + this.messengerConfig.getInboundQueueDeliveryTimeout();
            if (!this.inboundMessage.isDeliveryTimeoutNotified() && this.referenceDateTask.getReferenceCurrentTimeMillis() > timeout) {
                this.log.debug("Message '{}' was not delivered to Adapter {} within {} seconds.", (Object)this.inboundMessage.getMessageId(), (Object)this.inboundMessage.getAdapterId(), (Object)(this.messengerConfig.getInboundQueueDeliveryTimeout() / 1000L));
                this.messengerLog.log2db(533, this.inboundMessage.getUniqueId(), null);
                this.inboundMessage.deliveryTimeoutNotified();
            }
            if (this.canBeDelivered()) {
                this.startMessageDelivery();
            }
        }
        catch (Exception e) {
            this.log.error("{} while delivering message {} to adapter {}", (Object)e.getClass().getName(), (Object)this.inboundMessage.getMessageId(), (Object)this.inboundMessage.getAdapterId(), (Object)e);
        }
        finally {
            this.callback.run();
            Agreements.clearThreadCache();
            Profiles.clearThreadCache();
        }
        return null;
    }

    private void startMessageDelivery() {
        this.log.debug("starting delivery thread to {}", (Object)this.destinationAdapter);
        boolean successfulDelivery = false;
        try (Timer.Context queueAdapterTimer = this.metricsService.getTimer(XPMetrics.MESSAGES_INBOUND_QUEUE_ADAPTER_TIME).time();
             Timer.Context queueAdapterTimer2 = this.metricsService.getTimer(XPMetrics.MESSAGES_INBOUND_QUEUE_ADAPTER_TIME, this.inboundMessage.getSenderId()).time();){
            while (!successfulDelivery) {
                successfulDelivery = this.tryToDeliverMessageToAdapter();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.handleAdapterRejectedMessage("Delivery to adapter was interrupted");
        }
        catch (AdapterRejectedMessageException e) {
            this.handleAdapterRejectedMessage(e.getMessageResult().getDescription());
        }
        catch (AdapterCustomException e) {
            this.handleAdapterCustomError(e);
        }
        catch (AdapterAccessException e) {
            this.handleAdapterAccessProblem(e);
        }
        catch (BackEndMessageException e) {
            this.handleBackEndMessageException(e);
        }
        catch (Throwable e) {
            this.handleUnexpectedAdapterError(e);
        }
    }

    private void handleAdapterRejectedMessage(String errorDescription) {
        this.log.error("Adapter {} rejected message: {} reason:{}", (Object)this.destinationAdapter, (Object)this.inboundMessage.getMessageId(), (Object)errorDescription);
        this.storeBackendEnvelopeFileInDB();
        this.inboundMessageQueue.deleteFromInboundQueue(this.inboundMessage);
        this.archiveProcessor.sendFilesToArchive(this.inboundMessage.getUniqueId(), true);
        this.messageDAO.updateMessageStatus(this.inboundMessage.getUniqueId(), this.inboundMessage.getMessageId(), 4);
        this.messengerLog.log2db(530, this.inboundMessage.getUniqueId(), errorDescription);
        this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_FAILED).mark();
        this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_SENDER_FAILED, this.inboundMessage.getSenderId()).mark();
        this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_RECEIVER_FAILED, this.inboundMessage.getReceiverId()).mark();
    }

    private void handleUnexpectedAdapterError(Throwable e) {
        this.storeBackendEnvelopeFileInDB();
        this.messengerLog.log2db(514, this.inboundMessage.getUniqueId(), this.destinationAdapter + " / " + e.getMessage());
        this.log.fatal("Problem while transmitting to adapter:", e);
    }

    private void handleAdapterCustomError(AdapterCustomException e) {
        this.log.error("Adapter: {} custom error: {}", (Object)this.destinationAdapter, (Object)e.getResult().getDescription());
        this.storeBackendEnvelopeFileInDB();
        this.messengerLog.log2db(514, this.inboundMessage.getUniqueId(), e.getResult().getDescription());
    }

    private void handleBackEndMessageException(BackEndMessageException e) {
        String errorDescription = e.getMessage();
        this.log.error("Message failed and will be removed from queue:{}", (Object)errorDescription);
        this.storeBackendEnvelopeFileInDB();
        this.inboundMessageQueue.deleteFromInboundQueue(this.inboundMessage);
        this.archiveProcessor.sendFilesToArchive(this.inboundMessage.getUniqueId(), true);
        this.messageDAO.updateMessageStatus(this.inboundMessage.getUniqueId(), this.inboundMessage.getMessageId(), 4);
        this.messengerLog.log2db(530, this.inboundMessage.getUniqueId(), errorDescription);
        this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_FAILED).mark();
        this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_SENDER_FAILED, this.inboundMessage.getSenderId()).mark();
        this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_RECEIVER_FAILED, this.inboundMessage.getReceiverId()).mark();
    }

    private void handleAdapterAccessProblem(AdapterAccessException e) {
        AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(this.destinationAdapter);
        this.storeBackendEnvelopeFileInDB();
        this.messengerLog.log2db(514, this.inboundMessage.getUniqueId(), "communication with Adapter " + this.destinationAdapter + " failed");
        if (e.getErrorNumber() == 12005 && !adapterInfo.isDown()) {
            this.log.warn("Adapter: {} is down, it will be ignored. {}", (Object)this.destinationAdapter, (Object)e.getMessage());
            adapterInfo.setIsDown(true);
        } else {
            this.log.warn("Adapter: {} had a communication problem. message will be sent again: {}", (Object)this.destinationAdapter, (Object)e.getMessage());
        }
    }

    private boolean tryToDeliverMessageToAdapter() throws BackEndMessageException, AdapterRejectedMessageException, AdapterCustomException, AdapterAccessException, InterruptedException {
        boolean successfulDelivery = false;
        AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(this.destinationAdapter);
        try {
            this.messengerLog.log2db(67, this.inboundMessage.getUniqueId(), this.destinationAdapter);
            IAdapterAccess access = this.adapterAccessFactory.getAdapterAccess(adapterInfo);
            MessageResult resultDetail = access.sendInboundDocument(this.inboundMessage.getXpInboundMessage(), this.folders.getWorkInboundFolder());
            this.storeBackendEnvelopeFileInDB();
            this.log.info("Successfully delivered message to adapter {}: {}", (Object)this.destinationAdapter, (Object)resultDetail.getDescription());
            this.messengerLog.log2db(82, this.inboundMessage.getUniqueId(), resultDetail.getDescription());
            this.inboundMessageQueue.deleteFromInboundQueue(this.inboundMessage);
            if (this.inboundMessage.isAck()) {
                this.messengerLog.log2db(59, this.inboundMessage.getReferenceUniqueId(), this.destinationAdapter);
                this.messengerLog.log2db(82, this.inboundMessage.getReferenceUniqueId(), resultDetail.getDescription());
            } else {
                this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_SUCCESSFUL).mark();
                this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_SENDER_SUCCESSFUL, this.inboundMessage.getSenderId()).mark();
                this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_RECEIVER_SUCCESSFUL, this.inboundMessage.getReceiverId()).mark();
            }
            this.archiveAndLog();
            this.messageDAO.updateMessageStatus(this.inboundMessage.getUniqueId(), this.inboundMessage.getMessageId(), 3);
            this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_QUEUE_REMOVE_RATE).mark();
            successfulDelivery = true;
        }
        catch (AdapterAccessException e) {
            if (!adapterInfo.isDown() && this.numberOfConnectTries.get() < this.adapterConnectRetries) {
                this.log.warn("Could not access adapter '{}'. Will try again in {} seconds.", (Object)this.destinationAdapter, (Object)(this.adapterConnectInterval / 1000L));
                this.numberOfConnectTries.getAndIncrement();
                this.inboundMessageQueue.setNextTransmission(this.inboundMessage.getUniqueId(), this.referenceDateTask.getReferenceCurrentTimeMillis() + this.adapterConnectInterval);
                Thread.sleep(this.adapterConnectInterval);
            }
            throw e;
        }
        return successfulDelivery;
    }

    private void storeBackendEnvelopeFileInDB() {
        File backendEnvelope = new File(this.inboundMessage.getXpInboundMessage().getCurrentContentReferenceFolder(), "xp_backendmessage.xml");
        if (backendEnvelope.exists()) {
            try {
                this.messageWorkDataDAO.uploadMessageArtifactToDB(this.inboundMessage.getXpInboundMessage().getDatabaseId(), backendEnvelope);
            }
            catch (DbException e) {
                this.log.error("Could not upload backend envelope to db:", (Throwable)e);
            }
        }
    }

    private boolean canBeDelivered() {
        AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(this.destinationAdapter);
        this.log.debug("checking if adapter wants this message");
        if (Objects.isNull(this.inboundMessage.getXpInboundMessage())) {
            this.log.error("Can't deliver message (#{}#) to adapter '{}' because XpMessage is missing", (Object)this.inboundMessage.getUniqueId(), (Object)this.destinationAdapter);
            this.inboundMessageQueue.deleteFromInboundQueue(this.inboundMessage);
            this.messengerLog.log2db(530, this.inboundMessage.getUniqueId(), "XpMessage can't be restored");
            this.archiveAndLog();
            this.messageDAO.updateMessageStatus(this.inboundMessage.getUniqueId(), this.inboundMessage.getMessageId(), 4);
        } else if (this.inboundMessage.isErrorNotification() && !adapterInfo.supportsErrorNotifications()) {
            this.log.debug("adapter cannot handle Error Notification so we delete it from the queue");
            this.inboundMessageQueue.deleteFromInboundQueue(this.inboundMessage);
            this.messengerLog.log2db(530, this.inboundMessage.getUniqueId(), "Error Notifications not supported");
            this.archiveAndLog();
            this.messageDAO.updateMessageStatus(this.inboundMessage.getUniqueId(), this.inboundMessage.getMessageId(), 3);
        } else if (this.inboundMessage.isStatusResponse() && !adapterInfo.supportsStatusResponses()) {
            this.log.debug("adapter cannot handle Status Responses so we delete it from the queue");
            this.inboundMessageQueue.deleteFromInboundQueue(this.inboundMessage);
            this.messengerLog.log2db(98, this.inboundMessage.getUniqueId(), null);
            this.archiveAndLog();
            this.messageDAO.updateMessageStatus(this.inboundMessage.getUniqueId(), this.inboundMessage.getMessageId(), 3);
        } else {
            if (!this.inboundMessage.isAck() || this.inboundMessage.isAck() && adapterInfo.supportsAcknowledgements()) {
                if (!adapterInfo.supportsAttachments()) {
                    this.log.debug("Adapter does not support attachments - removing all attachments from the message.");
                    this.inboundMessage.removeAllAttachments();
                }
                this.log.debug("constructing backend message");
                adapterInfo.increaseCurrentThreads();
                return true;
            }
            this.log.debug("adapter cannot handle Acks so we delete it from the queue");
            this.inboundMessageQueue.deleteFromInboundQueue(this.inboundMessage);
            this.messengerLog.log2db(89, this.inboundMessage.getUniqueId(), null);
            this.archiveAndLog();
            this.messageDAO.updateMessageStatus(this.inboundMessage.getUniqueId(), this.inboundMessage.getMessageId(), 3);
        }
        return false;
    }

    private void archiveAndLog() {
        if (this.inboundMessage.isErrorNotification()) {
            File messageFolder = new File(this.folders.getWorkInboundFolder(), String.valueOf(this.inboundMessage.getUniqueId()));
            if (messageFolder.exists() && !FileUtils.deleteDirectory(messageFolder)) {
                this.log.error("Could not delete the work folder {}", (Object)messageFolder);
            }
        } else {
            this.archiveProcessor.sendFilesToArchive(this.inboundMessage.getUniqueId(), false);
            if (this.inboundMessage.isAck()) {
                this.messengerLog.log2dbWithHref(103, this.inboundMessage.getUniqueId(), "Message Id: " + this.inboundMessage.getReferenceMessageId(), this.inboundMessage.getReferenceMessageId(), this.inboundMessage.getReferenceUniqueId(), false);
            } else {
                this.messengerLog.log2db(101, this.inboundMessage.getUniqueId(), null);
            }
        }
    }
}

