/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.OutboundQueueMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ArchiveQueueDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.OutboundQueueMessageDAO;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutboundQueueExpiredMessagesTask {
    private static final Logger log = LogManager.getLogger((String)"Messenger.OutboundQueueExpiredMessagesTask");
    private final OutboundQueueMessageDAO outboundQueueMessageDAO;
    private final ArchiveQueueDAO archiveQueueDAO;

    public OutboundQueueExpiredMessagesTask(OutboundQueueMessageDAO outboundQueueMessageDAO, ArchiveQueueDAO archiveQueueDAO) {
        this.outboundQueueMessageDAO = outboundQueueMessageDAO;
        this.archiveQueueDAO = archiveQueueDAO;
    }

    public void initExpiredMassageTask() {
        log.debug("Starting OutboundQueueExpiredMessagesTask");
        try {
            List<OutboundQueueMessage> allExpiredMessages = this.outboundQueueMessageDAO.getExpiredMessages();
            for (OutboundQueueMessage message : allExpiredMessages) {
                log.info("Found OutboundQueueRecord 'IN TRANSFER' with expired TTL and start sendMessageThread for messageId: {}", (Object)message.getMessageId());
                this.outboundQueueMessageDAO.resetTransmissionState(message.getMessageId());
                int timeoutCount = this.archiveQueueDAO.resetTimedOutArchiveQueueMessages();
                if (timeoutCount > 0) {
                    log.info("Found and reset {} timed out archiving queue records", (Object)timeoutCount);
                    continue;
                }
                log.trace("Found no timed out archiving queue records");
            }
        }
        catch (DbException e) {
            log.fatal("Can't load expired messages 'IN TRANSFER' to init OutboundQueueExpiredMessagesTask: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Can't load expired messages 'IN TRANSFER' to init OutboundQueueExpiredMessagesTask", e);
        }
        log.debug("Finished OutboundQueueExpiredMessagesTask");
    }
}

