/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.ponton.xmlpipe.queue.IQueueMessage;
import de.ponton.xmlpipe.queue.XpMessageLoader;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class InboundQueueMessage
implements IQueueMessage {
    private final XpMessageLoader xpMessageLoader;
    private final ReferenceDateTask referenceDateTask;
    private final AdapterRegistry adapterRegistry;
    private final SchemataConfig schemataConfig;
    private final Supplier<Long> retryInterval;
    private final AtomicInteger tryCount = new AtomicInteger(0);
    private final AtomicLong queuedTimestamp = new AtomicLong(0L);
    private final AtomicLong lastTransmission = new AtomicLong(0L);
    private final AtomicBoolean inDelivery = new AtomicBoolean(false);
    private final AtomicBoolean notified = new AtomicBoolean(false);
    private XpInboundMessage xpInboundMessage;
    private final long messageDbId;
    private final String adapterId;
    private final AtomicBoolean xpMessageLoaded = new AtomicBoolean(false);
    private final ReadWriteLock rwLockForKeyStore = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLockForKeyStore.readLock();
    private final Lock writeLock = this.rwLockForKeyStore.writeLock();

    public InboundQueueMessage(XpMessageLoader xpMessageLoader, AdapterRegistry adapterRegistry, ReferenceDateTask referenceDateTask, SchemataConfig schemataConfig, Supplier<Long> retryInterval, XpInboundMessage xpInboundMessage) {
        this.xpMessageLoader = xpMessageLoader;
        this.referenceDateTask = referenceDateTask;
        this.adapterRegistry = adapterRegistry;
        this.schemataConfig = schemataConfig;
        this.retryInterval = retryInterval;
        this.xpInboundMessage = xpInboundMessage;
        this.messageDbId = xpInboundMessage.getDatabaseId();
        this.adapterId = xpInboundMessage.getAdapterId();
        this.xpMessageLoaded.set(true);
    }

    public InboundQueueMessage(XpMessageLoader xpMessageLoader, AdapterRegistry adapterRegistry, ReferenceDateTask referenceDateTask, SchemataConfig schemataConfig, Supplier<Long> retryInterval, long messageDbId, String adapterId) {
        this.xpMessageLoader = xpMessageLoader;
        this.referenceDateTask = referenceDateTask;
        this.adapterRegistry = adapterRegistry;
        this.schemataConfig = schemataConfig;
        this.retryInterval = retryInterval;
        this.xpInboundMessage = null;
        this.messageDbId = messageDbId;
        this.adapterId = adapterId;
    }

    private void loadXpMessagesIfNecessary() {
        this.readLock.lock();
        try {
            if (this.xpMessageLoaded.get()) {
                return;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            this.xpInboundMessage = this.xpMessageLoader.loadInboundMessage(this.messageDbId);
            this.xpMessageLoaded.set(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getUniqueId() {
        return this.messageDbId;
    }

    @Override
    public String getEndpoint() {
        return this.getAdapterId();
    }

    public boolean isInDelivery() {
        return this.inDelivery.get();
    }

    @Override
    public void deliveryStarted() {
        this.inDelivery.set(true);
    }

    @Override
    public void deliveryFinished() {
        this.inDelivery.set(false);
    }

    @Override
    public boolean canBeSent() {
        if (this.isInDelivery()) {
            return false;
        }
        AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(this.adapterId);
        if (adapterInfo == null || adapterInfo.isDown()) {
            this.lastTransmission.set(0L);
            return false;
        }
        long nextTryTime = this.lastTransmission.get() + this.retryInterval.get();
        return this.referenceDateTask.getReferenceCurrentTimeMillis() > nextTryTime;
    }

    @Override
    public void setNextTry() {
        this.lastTransmission.set(this.referenceDateTask.getReferenceCurrentTimeMillis());
    }

    @Override
    public int compareTo(IQueueMessage queueMessage) {
        if (queueMessage instanceof InboundQueueMessage) {
            InboundQueueMessage inboundQueueMessage = (InboundQueueMessage)queueMessage;
            int commonMessagePriority = this.getCommonMessagePriority().compareTo(inboundQueueMessage.getCommonMessagePriority());
            if (commonMessagePriority != 0) {
                return commonMessagePriority;
            }
            int messagePriorityCompareResult = inboundQueueMessage.getMessageTypePriority().compareTo(this.getMessageTypePriority());
            if (messagePriorityCompareResult != 0) {
                return messagePriorityCompareResult;
            }
            return Long.compare(this.getUniqueId(), inboundQueueMessage.getUniqueId());
        }
        return 1;
    }

    public boolean isSignal() {
        this.loadXpMessagesIfNecessary();
        return Objects.nonNull(this.xpInboundMessage) && this.xpInboundMessage.isSignal();
    }

    protected Integer getCommonMessagePriority() {
        this.loadXpMessagesIfNecessary();
        if (this.isSignal() && Objects.nonNull(this.xpInboundMessage) && "PONG".equals(this.xpInboundMessage.getMessageType())) {
            return 0;
        }
        return 1;
    }

    protected Integer getMessageTypePriority() {
        this.loadXpMessagesIfNecessary();
        if (Objects.isNull(this.xpInboundMessage)) {
            return 999;
        }
        if (!this.isSignal()) {
            return this.schemataConfig.getPriorityBySetTypeVersion(this.xpInboundMessage.getSchemaSet(), this.xpInboundMessage.getMessageType(), this.xpInboundMessage.getMessageVersion());
        }
        if (this.xpInboundMessage.isAck()) {
            String refSchemaSet = this.xpInboundMessage.getProcessingDirective("ReferenceSchemaSet");
            String refMessageType = this.xpInboundMessage.getProcessingDirective("ReferenceMessageType");
            String refMessageVersion = this.xpInboundMessage.getProcessingDirective("ReferenceSchemaVersion");
            return this.schemataConfig.getPriorityBySetTypeVersion(refSchemaSet, refMessageType, refMessageVersion);
        }
        return 1;
    }

    public int getPriority() {
        return Math.negateExact(this.getCommonMessagePriority()) + this.getMessageTypePriority();
    }

    boolean isErrorNotification() {
        this.loadXpMessagesIfNecessary();
        return Objects.nonNull(this.xpInboundMessage) && this.xpInboundMessage.isSignal() && this.xpInboundMessage.isErrorNotification();
    }

    public String getMessageId() {
        this.loadXpMessagesIfNecessary();
        return Objects.nonNull(this.xpInboundMessage) ? this.xpInboundMessage.getMessageId() : null;
    }

    boolean isAck() {
        this.loadXpMessagesIfNecessary();
        return Objects.nonNull(this.xpInboundMessage) && this.xpInboundMessage.isAck();
    }

    String getReferenceMessageId() {
        this.loadXpMessagesIfNecessary();
        return Objects.nonNull(this.xpInboundMessage) ? this.xpInboundMessage.getReferenceId() : null;
    }

    long getReferenceUniqueId() {
        this.loadXpMessagesIfNecessary();
        return Objects.nonNull(this.xpInboundMessage) ? this.xpInboundMessage.getReferenceDatabaseId() : 0L;
    }

    boolean isStatusResponse() {
        this.loadXpMessagesIfNecessary();
        return Objects.nonNull(this.xpInboundMessage) && this.xpInboundMessage.isStatusResponse();
    }

    void removeAllAttachments() {
        this.loadXpMessagesIfNecessary();
        if (Objects.nonNull(this.xpInboundMessage)) {
            this.xpInboundMessage.removeAllAttachments();
        }
    }

    String getSenderId() {
        this.loadXpMessagesIfNecessary();
        return Objects.nonNull(this.xpInboundMessage) ? this.xpInboundMessage.getSenderLocalId() : null;
    }

    String getReceiverId() {
        this.loadXpMessagesIfNecessary();
        return Objects.nonNull(this.xpInboundMessage) ? this.xpInboundMessage.getReceiverLocalId() : null;
    }

    public XpInboundMessage getXpInboundMessage() {
        this.loadXpMessagesIfNecessary();
        return this.xpInboundMessage;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public long getQueuedTimestamp() {
        return this.queuedTimestamp.get();
    }

    void setQueuedTimestamp(long timestamp) {
        this.queuedTimestamp.set(timestamp);
    }

    public void deliveryTimeoutNotified() {
        this.notified.set(true);
    }

    boolean isDeliveryTimeoutNotified() {
        return this.notified.get();
    }
}

