/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.httpadapter.configuration;

import de.ponton.xmlpipe.httpadapter.HttpAdapter;
import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.ExtendedGenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import java.io.IOException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebMvc
public class WebMVCConfiguration
implements WebMvcConfigurer {
    private static final String MESSENGER_ADDRESS = "localhost";
    private static final int MESSENGER_PORT = 0;
    private static final String MESSENGER_PATH = "/pontonxp/AdapterService";
    private static final int ADAPTER_SERVER_PORT = 0;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/swagger-ui/"}).resourceChain(false);
    }

    @Bean
    public BasicAuthenticationEntryPoint basicAuthenticationEntryPoint() {
        BasicAuthenticationEntryPoint basicAuthenticationEntryPoint = new BasicAuthenticationEntryPoint();
        basicAuthenticationEntryPoint.setRealmName("<<ANY_REALM>>");
        return basicAuthenticationEntryPoint;
    }

    @Bean
    public ExtendedGenericAdapter genericAdapter(HttpAdapter httpAdapter) throws AdapterException, IOException {
        ExtendedGenericAdapter genericAdapter = new ExtendedGenericAdapter(httpAdapter.getID());
        genericAdapter.setServerPort(0);
        genericAdapter.setProcessingTimeout(httpAdapter.getProcessingTimeout());
        genericAdapter.setEndAdapter((ISpecificAdapter)httpAdapter);
        genericAdapter.addMessengerConnection(MESSENGER_ADDRESS, 0, MESSENGER_PATH);
        return genericAdapter;
    }
}

