/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.httpadapter;

import de.ponton.xmlpipe.httpadapter.HttpAdapterConfig;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
public class CustomAuthenticationFilter
extends GenericFilterBean {
    private final HttpAdapterConfig httpAdapterConfig;

    public CustomAuthenticationFilter(HttpAdapterConfig httpAdapterConfig) {
        this.httpAdapterConfig = httpAdapterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication;
        String accessUser = this.httpAdapterConfig.getAcceptedUser();
        if (accessUser != null && !accessUser.isBlank() && (authentication = SecurityContextHolder.getContext().getAuthentication()) != null && !accessUser.equals(authentication.getName())) {
            response.getWriter().append("User not accepted by configuration.");
            ((HttpServletResponse)response).setStatus(403);
            return;
        }
        filterChain.doFilter(request, response);
    }
}

