/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket;

import de.ponton.api.websocket.WebSocketServerException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class SSLCertificateFactory {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.Api.SSLCertificateFactory");

    public KeyStore generateCertificate() throws WebSocketServerException {
        try {
            X500NameBuilder nameBuilder = new X500NameBuilder(RFC4519Style.INSTANCE);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair kp = keyPairGenerator.generateKeyPair();
            nameBuilder.addRDN(RFC4519Style.c, "DE");
            nameBuilder.addRDN(RFC4519Style.o, "PONTON GmbH");
            nameBuilder.addRDN(RFC4519Style.cn, "XP Api 2.0");
            X500Name newCertName = nameBuilder.build();
            Instant validFrom = OffsetDateTime.of(2000, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant();
            Instant validTo = OffsetDateTime.of(4000, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant();
            JcaX509v3CertificateBuilder v3Bldr = new JcaX509v3CertificateBuilder(newCertName, BigInteger.valueOf(System.currentTimeMillis()), Date.from(validFrom), Date.from(validTo), nameBuilder.build(), kp.getPublic());
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(kp.getPrivate());
            X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(v3Bldr.build(signer));
            v3Bldr.build(signer);
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(null);
            keystore.setEntry("websocket", new KeyStore.PrivateKeyEntry(kp.getPrivate(), new Certificate[]{certificate}), new KeyStore.PasswordProtection("asKnj720spdrvmas_ornOj".toCharArray()));
            return keystore;
        }
        catch (GeneralSecurityException | OperatorCreationException e) {
            LOG.error("could not generate ssl certificate.", e);
            throw new WebSocketServerException("could not generate SSL certificate", e);
        }
        catch (IOException e) {
            LOG.error("could not generate keystore.", (Throwable)e);
            throw new WebSocketServerException("could not generate ke<store", e);
        }
    }
}

