/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket;

import de.ponton.api.websocket.AbstractEndpoint;
import de.ponton.api.websocket.ApiCloseCodes;
import de.ponton.api.websocket.messages.ChallengeResponseHandler;
import de.ponton.api.websocket.messages.OutboundMessageHandler;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.WebSocketCloseCode;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.internal.messages.ProtocolNotReadyResponseMessage;
import de.ponton.xp.adapter.api.internal.messages.ProtocolReadyResponseMessage;
import jakarta.websocket.CloseReason;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApiOutboundEndpoint
extends AbstractEndpoint
implements MessageHandler.Whole<String>,
MessageHandler.Partial<byte[]> {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ApiOutboundEndpoint");
    private final OutboundMessageHandler outboundMessageHandler;

    public ApiOutboundEndpoint(ChallengeResponseHandler challengeResponseHandler, OutboundMessageHandler outboundMessageHandler) {
        super(challengeResponseHandler);
        this.outboundMessageHandler = outboundMessageHandler;
    }

    @Override
    public void onMessage(byte[] partialMessage, boolean last) {
        if (this.authenticated) {
            this.outboundMessageHandler.onMessage(partialMessage, last, this.session, this.adapterInfo);
        } else {
            super.onMessage(partialMessage, last);
        }
    }

    public void onMessage(String message) {
        if (this.authenticated) {
            SimpleProperties properties = this.convert(message);
            String messageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.UNKNOWN.name());
            LOG.debug("received message {}", (Object)messageType);
            switch (ProtocolMessageTypeEnum.valueOf((String)messageType)) {
                case ReadyMessage: {
                    this.handleReadyMessage();
                    break;
                }
                case NotReadyMessage: {
                    this.handleNotReadyMessage();
                    break;
                }
                case OutboundMessage: 
                case SyncOutboundMessage: {
                    this.outboundMessageHandler.initializeHandler(properties, this.session);
                    break;
                }
                default: {
                    this.closeSessionWithProtocolError("sent not supported message type " + messageType);
                    break;
                }
            }
        } else {
            this.closeUnauthenticatedSession();
        }
    }

    public boolean isOpen() {
        if (this.session == null) {
            return false;
        }
        return this.session.isOpen();
    }

    @Override
    public void onClose(Session session, CloseReason closeReason) {
        this.outboundMessageHandler.onClose();
        super.onClose(session, closeReason);
    }

    private void handleReadyMessage() {
        this.adapterInfo.setReadyForMessages(true);
        try {
            this.session.getBasicRemote().sendText(ProtocolReadyResponseMessage.createBuilder().build().toWireFormat(), true);
        }
        catch (IOException e) {
            try {
                this.session.close(new CloseReason((CloseReason.CloseCode)new ApiCloseCodes(WebSocketCloseCode.INTERNAL_ERROR), e.toString()));
            }
            catch (IOException ex) {
                LOG.error("could not close session.", (Throwable)ex);
            }
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handleNotReadyMessage() {
        this.adapterInfo.setReadyForMessages(false);
        try {
            this.session.getBasicRemote().sendText(ProtocolNotReadyResponseMessage.createBuilder().build().toWireFormat(), true);
        }
        catch (IOException e) {
            try {
                this.session.close(new CloseReason((CloseReason.CloseCode)new ApiCloseCodes(WebSocketCloseCode.INTERNAL_ERROR), e.toString()));
            }
            catch (IOException ex) {
                LOG.error("could not close session.", (Throwable)ex);
            }
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

