/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api;

import de.ponton.api.WebSocketAdapterInfo;
import de.ponton.api.websocket.WebSocketConnection;
import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.AdapterInfoDAO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdapterGateway {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.AdapterGateway");
    private final AdapterInfoDAO adapterInfoDao;

    public AdapterGateway(AdapterInfoDAO adapterInfoDAO) {
        this.adapterInfoDao = adapterInfoDAO;
    }

    public synchronized WebSocketAdapterInfo registerAdapterSession(String adapterId, String instanceId, WebSocketConnection connection, boolean adapterSupportsStatusUpdate, boolean adapterSupportsErrorNotification, boolean adapterSupportsInboundMessage, boolean adapterSupportsArchive) throws AdapterException {
        AdapterInfo adapterInfo = this.adapterInfoDao.getAdapter(adapterId);
        if (adapterInfo == null) {
            return this.registerNewAdapter(adapterId, instanceId, connection, adapterSupportsStatusUpdate, adapterSupportsErrorNotification, adapterSupportsInboundMessage, adapterSupportsArchive);
        }
        if (adapterInfo instanceof WebSocketAdapterInfo) {
            return this.addSession((WebSocketAdapterInfo)adapterInfo, instanceId, connection);
        }
        LOG.error("adapter id {} is already in use by non-websocket-adapter", (Object)adapterId);
        throw new AdapterException("adapter ID is already in use");
    }

    private WebSocketAdapterInfo addSession(WebSocketAdapterInfo adapterInfo, String instanceId, WebSocketConnection webSocketConnection) throws AdapterException {
        if (!instanceId.equals(adapterInfo.getAddress())) {
            LOG.error("expected instance id: {} but received: {}", (Object)adapterInfo.getAddress(), (Object)instanceId);
            throw new AdapterException("adapter instance was rejected by Messenger");
        }
        adapterInfo.addWebSocketConnection(webSocketConnection);
        return adapterInfo;
    }

    private WebSocketAdapterInfo registerNewAdapter(String adapterId, String instanceId, WebSocketConnection webSocketConnection, boolean adapterSupportsStatusUpdate, boolean adapterSupportsErrorNotification, boolean adapterSupportsInboundMessage, boolean adapterSupportsArchive) throws AdapterException {
        LOG.info("Registering adapter: {} instanceID: {} [supportsStatusUpdate:{} / supportsErrorNotification={} / supportsInboundMessage={} / supportsArchive={}]", (Object)adapterId, (Object)instanceId, (Object)adapterSupportsStatusUpdate, (Object)adapterSupportsErrorNotification, (Object)adapterSupportsInboundMessage, (Object)adapterSupportsArchive);
        WebSocketAdapterInfo webSocketAdapterInfo = WebSocketAdapterInfo.createBuilder().setAdapterId(adapterId).setAdapterInstanceId(instanceId).setProcessingTimeout(webSocketConnection.getTimeout()).setSupportStatusUpdate(adapterSupportsStatusUpdate).setSupportErrorNotification(adapterSupportsErrorNotification).setSupportInboundMessage(adapterSupportsInboundMessage).setSupportArchive(adapterSupportsArchive).build();
        webSocketAdapterInfo.setAddress(instanceId);
        webSocketAdapterInfo.addWebSocketConnection(webSocketConnection);
        try {
            this.adapterInfoDao.addAdapter(webSocketAdapterInfo);
        }
        catch (DbException e) {
            throw new AdapterException("could not register adapter in database. " + e.getMessage());
        }
        return webSocketAdapterInfo;
    }
}

