/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.messages.internal;

import de.ponton.xp.adapter.api.domainvalues.InboundMetaData;
import de.ponton.xp.adapter.api.messages.InboundMessage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InboundMessageImpl
implements InboundMessage {
    private static final Logger LOG = Logger.getLogger(InboundMessageImpl.class.getName());
    private final InboundMetaData inboundMetaData;
    private final Path path;
    private final List<InputStream> createdInputStreams;

    public static InboundMessageBuilder newBuilder() {
        return new InboundMessageBuilder();
    }

    private InboundMessageImpl(InboundMetaData inboundMetaData, Path path) {
        Objects.requireNonNull(inboundMetaData, "inboundMetaData must not be NULL");
        Objects.requireNonNull(path, "path must not be NULL");
        this.inboundMetaData = inboundMetaData;
        this.path = path;
        this.createdInputStreams = new ArrayList<InputStream>();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(this.path, new OpenOption[0]));
        this.createdInputStreams.add(inputStream);
        return inputStream;
    }

    @Override
    public InboundMetaData getInboundMetaData() {
        return this.inboundMetaData;
    }

    public void purge() {
        for (InputStream inputStream : this.createdInputStreams) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not close input stream.", e);
            }
        }
    }

    public static class InboundMessageBuilder {
        private InboundMetaData inboundMetaData;
        private Path path;

        public InboundMessageBuilder setInboundMetaData(InboundMetaData inboundMetaData) {
            this.inboundMetaData = inboundMetaData;
            return this;
        }

        public InboundMessageBuilder setPath(Path path) {
            this.path = path;
            return this;
        }

        public InboundMessageImpl build() {
            return new InboundMessageImpl(this.inboundMetaData, this.path);
        }
    }
}

