/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.messages;

import de.ponton.xp.adapter.api.domainvalues.ConversationId;
import de.ponton.xp.adapter.api.domainvalues.CreationTime;
import de.ponton.xp.adapter.api.domainvalues.DisplayName;
import de.ponton.xp.adapter.api.domainvalues.Filename;
import de.ponton.xp.adapter.api.domainvalues.LogInfo;
import de.ponton.xp.adapter.api.domainvalues.MessageId;
import de.ponton.xp.adapter.api.domainvalues.MessageType;
import de.ponton.xp.adapter.api.domainvalues.MessageTypeName;
import de.ponton.xp.adapter.api.domainvalues.MessageTypeVersion;
import de.ponton.xp.adapter.api.domainvalues.MessageUniqueId;
import de.ponton.xp.adapter.api.domainvalues.MimeType;
import de.ponton.xp.adapter.api.domainvalues.OutboundStatusEnum;
import de.ponton.xp.adapter.api.domainvalues.PayloadSize;
import de.ponton.xp.adapter.api.domainvalues.ProcessingDirective;
import de.ponton.xp.adapter.api.domainvalues.ReceiverId;
import de.ponton.xp.adapter.api.domainvalues.SchemaSet;
import de.ponton.xp.adapter.api.domainvalues.SenderId;
import de.ponton.xp.adapter.api.domainvalues.SequenceNumber;
import de.ponton.xp.adapter.api.domainvalues.TransferId;
import de.ponton.xp.adapter.api.domainvalues.internal.ReceptionTimeImpl;
import de.ponton.xp.adapter.api.domainvalues.internal.StatusMetaDataImpl;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.MetaDataPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.messages.OutboundMessageStatusUpdate;
import de.ponton.xp.adapter.api.messages.internal.OutboundMessageStatusUpdateImpl;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OutboundMessageStatusUpdateFactory {
    private static final OutboundMessageStatusUpdateFactory instance = new OutboundMessageStatusUpdateFactory();

    public static OutboundMessageStatusUpdateFactory getInstance() {
        return instance;
    }

    public OutboundMessageStatusUpdate createOutboundMessageStatusUpdate(SimpleProperties properties) {
        StatusMetaDataImpl.StatusMetaDataBuilder statusMetaDataBuilder = (StatusMetaDataImpl.StatusMetaDataBuilder)((StatusMetaDataImpl.StatusMetaDataBuilder)((StatusMetaDataImpl.StatusMetaDataBuilder)((StatusMetaDataImpl.StatusMetaDataBuilder)((StatusMetaDataImpl.StatusMetaDataBuilder)((StatusMetaDataImpl.StatusMetaDataBuilder)((StatusMetaDataImpl.StatusMetaDataBuilder)((StatusMetaDataImpl.StatusMetaDataBuilder)StatusMetaDataImpl.newBuilder().setSenderId(new SenderId(properties.getProperty(MetaDataPropertiesEnum.SENDER_ID)))).setReceiverId(new ReceiverId(properties.getProperty(MetaDataPropertiesEnum.RECEIVER_ID)))).setMessageId(new MessageId(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_ID)))).setConversationId(new ConversationId(properties.getProperty(MetaDataPropertiesEnum.CONVERSATION_ID)))).setMessageType(MessageType.newBuilder().setName(new MessageTypeName(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_TYPE))).setVersion(new MessageTypeVersion(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_VERSION))).setSchemaSet(new SchemaSet(properties.getProperty(MetaDataPropertiesEnum.SCHEMA_SET))).setDisplayName(new DisplayName(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_TYPE_DISPLAY_NAME))).setMimeType(new MimeType(properties.getProperty(MetaDataPropertiesEnum.MIME_TYPE))).build())).setSequenceNumber(new SequenceNumber(Integer.parseInt(properties.getProperty(MetaDataPropertiesEnum.SEQUENCE_NUMBER))))).setOriginalFilename(new Filename(properties.getProperty(MetaDataPropertiesEnum.FILENAME)))).addProcessingDirectives((List)this.getProcessingDirectives(properties));
        if (Objects.nonNull(properties.getProperty(MetaDataPropertiesEnum.CREATION_TIME)) && !"UNKNOWN".equals(properties.getProperty(MetaDataPropertiesEnum.CREATION_TIME))) {
            statusMetaDataBuilder.setCreationTime(new CreationTime(Instant.ofEpochMilli(Long.parseLong(properties.getProperty(MetaDataPropertiesEnum.CREATION_TIME)))));
        }
        if (Objects.nonNull(properties.getProperty(MetaDataPropertiesEnum.RECEPTION_TIME)) && !"UNKNOWN".equals(properties.getProperty(MetaDataPropertiesEnum.RECEPTION_TIME))) {
            statusMetaDataBuilder.setReceptionTime(new ReceptionTimeImpl(Instant.ofEpochMilli(Long.parseLong(properties.getProperty(MetaDataPropertiesEnum.RECEPTION_TIME)))));
        }
        if (Objects.nonNull(properties.getProperty(MetaDataPropertiesEnum.LOG_INFO))) {
            statusMetaDataBuilder.setLogInfo(new LogInfo(properties.getProperty(MetaDataPropertiesEnum.LOG_INFO)));
        }
        if (Objects.nonNull(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_UNIQUE_ID))) {
            statusMetaDataBuilder.setMessageUniqueId(new MessageUniqueId(Long.parseLong(properties.getProperty(MetaDataPropertiesEnum.MESSAGE_UNIQUE_ID))));
        }
        if (Objects.nonNull(properties.getProperty(AdapterPropertiesEnum.CONTENT_LENGTH))) {
            statusMetaDataBuilder.setPayloadSize(new PayloadSize(Integer.parseInt(properties.getProperty(AdapterPropertiesEnum.CONTENT_LENGTH))));
        }
        StatusMetaDataImpl statusMetaData = statusMetaDataBuilder.build();
        return OutboundMessageStatusUpdateImpl.newBuilder().setTransferId(new TransferId(properties.getProperty(AdapterPropertiesEnum.TRANSFER_ID))).setStatusMetaData(statusMetaData).setResult(OutboundStatusEnum.valueOf(properties.getProperty(AdapterPropertiesEnum.RESULT))).setDetailText(properties.getProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT)).setFinal(Boolean.parseBoolean(properties.getProperty(AdapterPropertiesEnum.IS_FINAL))).build();
    }

    private List<ProcessingDirective> getProcessingDirectives(SimpleProperties properties) {
        ArrayList<ProcessingDirective> processingDirectives = new ArrayList<ProcessingDirective>();
        Map<String, String> processingDirectiveValues = properties.getProperties(MetaDataPropertiesEnum.PROCESSING_DIRECTIVE);
        for (Map.Entry<String, String> entry : processingDirectiveValues.entrySet()) {
            processingDirectives.add(ProcessingDirective.create(entry.getKey(), entry.getValue()));
        }
        return processingDirectives;
    }
}

