/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal.messages;

import de.ponton.xp.adapter.api.domainvalues.SerializeableDomainValue;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.MetaDataPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public abstract class ProtocolMessage {
    private final SimpleProperties properties = new SimpleProperties();

    ProtocolMessage(ProtocolMessageTypeEnum messageType) {
        this.properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, messageType.name());
    }

    public String toWireFormat() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.properties.store(out, "Generated by Ponton XP API 2.0.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString(StandardCharsets.UTF_8);
    }

    protected void setDomainValueProperty(MetaDataPropertiesEnum keyEnum, SerializeableDomainValue value) {
        if (keyEnum != null) {
            this.setDomainValueProperty(keyEnum.toString(), value);
        }
    }

    protected void setDomainValueProperty(AdapterPropertiesEnum keyEnum, SerializeableDomainValue value) {
        if (keyEnum != null) {
            this.setDomainValueProperty(keyEnum.toString(), value);
        }
    }

    protected void setDomainValueProperty(String key, SerializeableDomainValue value) {
        if (key != null && value != null) {
            this.properties.setProperty(key, value.getStringValue());
        }
    }

    protected void setProperty(AdapterPropertiesEnum enumKey, String value) {
        if (enumKey != null) {
            this.setProperty(enumKey.toString(), value);
        }
    }

    protected void setProperty(MetaDataPropertiesEnum enumKey, String value) {
        if (enumKey != null) {
            this.setProperty(enumKey.toString(), value);
        }
    }

    protected void setProperty(String key, String value) {
        if (key != null && value != null) {
            this.properties.setProperty(key, value);
        }
    }

    protected void setProperties(MetaDataPropertiesEnum enumKey, Map<String, String> values) {
        if (enumKey != null && values != null) {
            this.properties.setProperties(enumKey, values);
        }
    }

    protected String getProperty(String key) {
        return this.properties.getProperty(key);
    }
}

